/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.util.MultiHash;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ApacheDifference
extends Difference {
    public static final int DIFF_MODULE_MISSING = 400;
    public static final int DIFF_MODULE_LOCATION = 401;
    public static final int DIFF_DIRECTIVE_MISSING = 402;
    public static final int DIFF_DIRECTIVE_MISMATCH = 403;
    public static final int DIFF_GROUP_MISSING = 404;
    public static final int DIFF_GROUP_KEY_MISSING = 405;
    public static final int DIFF_GROUP_VALUE_MISMATCH = 406;

    public ApacheDifference() {
    }

    public ApacheDifference(int type, String srcVal, String dstVal) {
        super(type, null, srcVal, dstVal, 0, 0);
    }

    private static Vector doDiff(MultiHash srcDirectives, MultiHash srcModules, MultiHash srcGroups, MultiHash dstDirectives, MultiHash dstModules, MultiHash dstGroups) {
        Vector diffs = ApacheDifference.diffModules(srcModules, dstModules);
        diffs.addAll(ApacheDifference.diffDirectives(srcDirectives, dstDirectives));
        diffs.addAll(ApacheDifference.diffGroups(srcGroups, dstGroups));
        return diffs;
    }

    private static Vector diffGroups(MultiHash src, MultiHash dst) {
        Vector<ApacheDifference> diffs = new Vector<ApacheDifference>();
        Enumeration srcKeys = src.keys();
        while (srcKeys.hasMoreElements()) {
            String theKey = (String)srcKeys.nextElement();
            Vector dstGroups = dst.getAll(theKey);
            if (dstGroups == null || dstGroups.size() == 0) {
                diffs.addElement(new ApacheDifference(404, theKey, null));
                continue;
            }
            Vector srcGroups = src.getAll(theKey);
            if (srcGroups.size() > dstGroups.size()) {
                diffs.addElement(new ApacheDifference(404, theKey, null));
            } else if (dstGroups.size() > srcGroups.size()) {
                diffs.addElement(new ApacheDifference(404, null, theKey));
            }
            for (int i = 0; i < srcGroups.size(); ++i) {
                MultiHash srcGroup = (MultiHash)srcGroups.elementAt(i);
                if (i >= dstGroups.size()) continue;
                MultiHash dstGroup = (MultiHash)dstGroups.elementAt(i);
                diffs.addAll(ApacheDifference.diffOneGroup(theKey, srcGroup, dstGroup));
            }
        }
        Enumeration dstKeys = dst.keys();
        while (dstKeys.hasMoreElements()) {
            String theKey = (String)dstKeys.nextElement();
            if (src.get(theKey) != null) continue;
            diffs.addElement(new ApacheDifference(404, null, theKey));
        }
        return diffs;
    }

    private static Vector diffOneGroup(String inGroupName, MultiHash src, MultiHash dst) {
        Object srcVal;
        Vector<ApacheDifference> diffs = new Vector<ApacheDifference>();
        Enumeration srcKeys = src.keys();
        while (srcKeys.hasMoreElements()) {
            String theKey = (String)srcKeys.nextElement();
            Object dstVal = dst.getSingle(theKey);
            if (dstVal == null) {
                diffs.addElement(new ApacheDifference(405, theKey, null));
                continue;
            }
            srcVal = src.getSingle(theKey);
            if (srcVal instanceof String && dstVal instanceof String) {
                if (((String)srcVal).equals(dstVal)) continue;
                diffs.addElement(new ApacheDifference(406, inGroupName + ":" + theKey + "=" + (String)srcVal, inGroupName + ":" + theKey + "=" + (String)dstVal));
                continue;
            }
            if (!(srcVal instanceof MultiHash) || !(dstVal instanceof MultiHash)) continue;
            diffs.addAll(ApacheDifference.diffOneGroup(inGroupName + ":" + theKey, (MultiHash)srcVal, (MultiHash)dstVal));
        }
        Enumeration dstKeys = dst.keys();
        while (dstKeys.hasMoreElements()) {
            String theKey = (String)dstKeys.nextElement();
            srcVal = src.getSingle(theKey);
            if (srcVal != null) continue;
            diffs.addElement(new ApacheDifference(405, null, theKey));
        }
        return diffs;
    }

    private static Vector diffModules(MultiHash src, MultiHash dst) {
        return ApacheDifference.diffFlatStringTable(src, dst, 400, 401);
    }

    private static Vector diffDirectives(MultiHash src, MultiHash dst) {
        return ApacheDifference.diffFlatStringTable(src, dst, 402, 403);
    }

    private static Vector diffFlatStringTable(MultiHash src, MultiHash dst, int inMissingType, int inMismatchType) {
        Object srcVal;
        Vector<ApacheDifference> diffs = new Vector<ApacheDifference>();
        Enumeration srcKeys = src.keys();
        while (srcKeys.hasMoreElements()) {
            String theKey = (String)srcKeys.nextElement();
            String dstVal = (String)dst.getSingle(theKey);
            if (dstVal == null) {
                diffs.addElement(new ApacheDifference(inMissingType, theKey, null));
                continue;
            }
            srcVal = (String)src.getSingle(theKey);
            if (((String)srcVal).equals(dstVal)) continue;
            diffs.addElement(new ApacheDifference(inMismatchType, theKey + "=" + (String)srcVal, theKey + "=" + dstVal));
        }
        Enumeration dstKeys = dst.keys();
        while (dstKeys.hasMoreElements()) {
            String theKey = (String)dstKeys.nextElement();
            srcVal = src.getSingle(theKey);
            if (srcVal != null) continue;
            diffs.addElement(new ApacheDifference(inMissingType, null, theKey));
        }
        return diffs;
    }

    private static void parse(BufferedReader inFile, MultiHash outDirectives, MultiHash outModules, MultiHash outGroups) throws IOException {
        String line;
        while ((line = inFile.readLine()) != null) {
            if (line.startsWith("#")) continue;
            line = line.trim();
            while (line.endsWith("\\")) {
                line = line + inFile.readLine().trim();
            }
            if (line.startsWith("<")) {
                ApacheDifference.parseGroup(line, inFile, outGroups);
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(line, "\t ");
            if (!tokenizer.hasMoreTokens()) continue;
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase("LoadModule")) {
                String key = tokenizer.nextToken().trim();
                String value = tokenizer.nextToken().trim();
                outModules.put(key, value);
                continue;
            }
            String restOfLine = line.substring(line.indexOf(token) + token.length());
            outDirectives.put(token, restOfLine.trim());
        }
    }

    private static void parseGroup(String line, BufferedReader inFile, MultiHash outGroups) throws IOException {
        String sectionName = line;
        StringTokenizer tokenizer = new StringTokenizer(line, "\t <", false);
        String tagName = tokenizer.nextToken();
        MultiHash section = new MultiHash();
        while (true) {
            line = inFile.readLine();
            line.trim();
            if (line.startsWith("</" + tagName)) break;
            if (line.startsWith("<")) {
                ApacheDifference.parseGroup(line, inFile, section);
                continue;
            }
            tokenizer = new StringTokenizer(line, " \t", false);
            if (!tokenizer.hasMoreElements()) continue;
            String key = tokenizer.nextToken();
            section.put(key, line.substring(line.indexOf(key) + key.length(), line.length()));
        }
        outGroups.put(sectionName, section);
    }

    public String toString() {
        switch (this.getType()) {
            case 400: {
                if (this.getSourceVal() != null) {
                    return "Module not loaded in destination: " + this.getSourceVal();
                }
                return "Module not loaded in source: " + this.getDestVal();
            }
            case 401: {
                return "Module locations differ. Source has: " + this.getSourceVal() + ", destination has: " + this.getDestVal();
            }
            case 402: {
                if (this.getDestVal() != null) {
                    return "Directive missing from source: " + this.getDestVal();
                }
                return "Directive missing from destination: " + this.getSourceVal();
            }
            case 403: {
                return "Directive mismatch. source is: " + this.getSourceVal() + ", destination is: " + this.getDestVal();
            }
            case 404: {
                if (this.getDestVal() != null) {
                    return "Configuration group missing from source: " + this.getDestVal();
                }
                return "Configuration group missing from destination: " + this.getSourceVal();
            }
            case 405: {
                if (this.getDestVal() != null) {
                    return "Group directive missing from source: " + this.getDestVal();
                }
                return "Group directive missing from destination: " + this.getSourceVal();
            }
            case 406: {
                return "Group directive mismatch. source is: " + this.getSourceVal() + ", destination is: " + this.getDestVal();
            }
        }
        throw new IllegalArgumentException("Invalid type: " + this.getType());
    }

    public static Vector diffApacheFiles(InputStream inSourceFile, InputStream inDestFile) throws IOException {
        BufferedReader srcReader = new BufferedReader(new InputStreamReader(inSourceFile));
        BufferedReader destReader = new BufferedReader(new InputStreamReader(inDestFile));
        MultiHash srcDirectives = new MultiHash();
        MultiHash srcModules = new MultiHash();
        MultiHash srcGroups = new MultiHash();
        MultiHash dstDirectives = new MultiHash();
        MultiHash dstModules = new MultiHash();
        MultiHash dstGroups = new MultiHash();
        try {
            ApacheDifference.parse(srcReader, srcDirectives, srcModules, srcGroups);
            ApacheDifference.parse(destReader, dstDirectives, dstModules, dstGroups);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        return ApacheDifference.doDiff(srcDirectives, srcModules, srcGroups, dstDirectives, dstModules, dstGroups);
    }
}

