/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ASCII_CharStream {
    public static final boolean staticFlag = true;
    static int bufsize;
    static int available;
    static int tokenBegin;
    public static int bufpos;
    private static int[] bufline;
    private static int[] bufcolumn;
    private static int column;
    private static int line;
    private static boolean prevCharIsCR;
    private static boolean prevCharIsLF;
    private static Reader inputStream;
    private static char[] buffer;
    private static int maxNextCharInd;
    private static int inBuf;

    private static final void ExpandBuff(boolean wrapAround) {
        char[] newbuffer = new char[bufsize + 2048];
        int[] newbufline = new int[bufsize + 2048];
        int[] newbufcolumn = new int[bufsize + 2048];
        try {
            if (wrapAround) {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
                buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
                bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
                bufcolumn = newbufcolumn;
                maxNextCharInd = bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                bufcolumn = newbufcolumn;
                maxNextCharInd = bufpos -= tokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error(t.getMessage());
        }
        available = bufsize += 2048;
        tokenBegin = 0;
    }

    private static final void FillBuff() throws IOException {
        if (maxNextCharInd == available) {
            if (available == bufsize) {
                if (tokenBegin > 2048) {
                    maxNextCharInd = 0;
                    bufpos = 0;
                    available = tokenBegin;
                } else if (tokenBegin < 0) {
                    maxNextCharInd = 0;
                    bufpos = 0;
                } else {
                    ASCII_CharStream.ExpandBuff(false);
                }
            } else if (available > tokenBegin) {
                available = bufsize;
            } else if (tokenBegin - available < 2048) {
                ASCII_CharStream.ExpandBuff(true);
            } else {
                available = tokenBegin;
            }
        }
        try {
            int i = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd);
            if (i == -1) {
                inputStream.close();
                throw new IOException();
            }
            maxNextCharInd += i;
            return;
        }
        catch (IOException e) {
            --bufpos;
            ASCII_CharStream.backup(0);
            if (tokenBegin == -1) {
                tokenBegin = bufpos;
            }
            throw e;
        }
    }

    public static final char BeginToken() throws IOException {
        tokenBegin = -1;
        char c = ASCII_CharStream.readChar();
        tokenBegin = bufpos;
        return c;
    }

    private static final void UpdateLineColumn(char c) {
        ++column;
        if (prevCharIsLF) {
            prevCharIsLF = false;
            column = 1;
            ++line;
        } else if (prevCharIsCR) {
            prevCharIsCR = false;
            if (c == '\n') {
                prevCharIsLF = true;
            } else {
                column = 1;
                ++line;
            }
        }
        switch (c) {
            case '\r': {
                prevCharIsCR = true;
                break;
            }
            case '\n': {
                prevCharIsLF = true;
                break;
            }
            case '\t': {
                --column;
                column += 8 - (column & 7);
                break;
            }
        }
        ASCII_CharStream.bufline[ASCII_CharStream.bufpos] = line;
        ASCII_CharStream.bufcolumn[ASCII_CharStream.bufpos] = column;
    }

    public static final char readChar() throws IOException {
        if (inBuf > 0) {
            --inBuf;
            return (char)(0xFF & buffer[bufpos == bufsize - 1 ? (bufpos = 0) : (bufpos = bufpos + 1)]);
        }
        if (++bufpos >= maxNextCharInd) {
            ASCII_CharStream.FillBuff();
        }
        char c = (char)(0xFF & buffer[bufpos]);
        ASCII_CharStream.UpdateLineColumn(c);
        return c;
    }

    public static final int getColumn() {
        return bufcolumn[bufpos];
    }

    public static final int getLine() {
        return bufline[bufpos];
    }

    public static final int getEndColumn() {
        return bufcolumn[bufpos];
    }

    public static final int getEndLine() {
        return bufline[bufpos];
    }

    public static final int getBeginColumn() {
        return bufcolumn[tokenBegin];
    }

    public static final int getBeginLine() {
        return bufline[tokenBegin];
    }

    public static final void backup(int amount) {
        inBuf += amount;
        if ((bufpos -= amount) < 0) {
            bufpos += bufsize;
        }
    }

    public ASCII_CharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        if (inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static ASCII_CharStream.  You must\n       either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        inputStream = dstream;
        line = startline;
        column = startcolumn - 1;
        available = bufsize = buffersize;
        buffer = new char[buffersize];
        bufline = new int[buffersize];
        bufcolumn = new int[buffersize];
    }

    public ASCII_CharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public static void ReInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        inputStream = dstream;
        line = startline;
        column = startcolumn - 1;
        if (buffer == null || buffersize != buffer.length) {
            available = bufsize = buffersize;
            buffer = new char[buffersize];
            bufline = new int[buffersize];
            bufcolumn = new int[buffersize];
        }
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tokenBegin = 0;
        bufpos = -1;
    }

    public static void ReInit(Reader dstream, int startline, int startcolumn) {
        ASCII_CharStream.ReInit(dstream, startline, startcolumn, 4096);
    }

    public ASCII_CharStream(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public ASCII_CharStream(InputStream dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public static void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
        ASCII_CharStream.ReInit(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public static void ReInit(InputStream dstream, int startline, int startcolumn) {
        ASCII_CharStream.ReInit(dstream, startline, startcolumn, 4096);
    }

    public static final String GetImage() {
        if (bufpos >= tokenBegin) {
            return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
        }
        return new String(buffer, tokenBegin, bufsize - tokenBegin) + new String(buffer, 0, bufpos + 1);
    }

    public static final char[] GetSuffix(int len) {
        char[] ret = new char[len];
        if (bufpos + 1 >= len) {
            System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
        } else {
            System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0, len - bufpos - 1);
            System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
        }
        return ret;
    }

    public static void Done() {
        buffer = null;
        bufline = null;
        bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int newLine, int newCol) {
        int i;
        int start = tokenBegin;
        int len = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int j = 0;
        int k = 0;
        int nextColDiff = 0;
        int columnDiff = 0;
        for (i = 0; i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize]; ++i) {
            ASCII_CharStream.bufline[j] = newLine;
            nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
            ASCII_CharStream.bufcolumn[j] = newCol + columnDiff;
            columnDiff = nextColDiff;
        }
        if (i < len) {
            ASCII_CharStream.bufline[j] = newLine++;
            ASCII_CharStream.bufcolumn[j] = newCol + columnDiff;
            while (i++ < len) {
                j = start % bufsize;
                if (bufline[j] != bufline[++start % bufsize]) {
                    ASCII_CharStream.bufline[j] = newLine++;
                    continue;
                }
                ASCII_CharStream.bufline[j] = newLine;
            }
        }
        line = bufline[j];
        column = bufcolumn[j];
    }

    static {
        bufpos = -1;
        column = 0;
        line = 1;
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
    }
}

