/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.ObjectUtil;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class VariableSettingsHolder
implements VariableSettingsSource,
RPCSerializable,
Cloneable {
    private Hashtable mVarTable = new Hashtable();
    private Vector mVarNames = new Vector();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char VAR_SEP_CHAR = '=';
    private boolean mContentsDeclarative = false;

    public VariableSettingsHolder() {
    }

    public VariableSettingsHolder(boolean areContentsDeclarative) {
        this.mContentsDeclarative = areContentsDeclarative;
    }

    public VariableSettingsHolder(com.sun.n1.util.vars.VariableSettingsSource vars) {
        String[] names = vars.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            String val = vars.getVarValue(names[i]);
            this.setVarValue(names[i], val);
        }
    }

    public VariableSettingsHolder(com.sun.n1.util.vars.VariableSettingsSource vars, boolean areContentsDeclarative) {
        this(vars);
        this.mContentsDeclarative = areContentsDeclarative;
    }

    public String getVarValue(String varName) {
        return (String)this.mVarTable.get(varName);
    }

    public String[] getVarNames() {
        return this.mVarNames.toArray(EMPTY_STRING_ARRAY);
    }

    public void setVarValue(String varName, String value) {
        if (this.mVarTable.put(varName, value) == null) {
            this.mVarNames.addElement(varName);
        }
    }

    public void removeVarValue(String varName) {
        if (this.mVarTable.remove(varName) != null) {
            this.mVarNames.remove(varName);
        }
    }

    public boolean containsVarValue(String varName) {
        return this.mVarTable.containsKey(varName);
    }

    public int size() {
        return this.mVarNames.size();
    }

    public String[] getVarSettings() {
        int len = this.mVarNames.size();
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            String name = (String)this.mVarNames.elementAt(i);
            String value = this.getVarValue(name);
            StringBuffer buf = new StringBuffer(name.length() + value.length() + 1);
            buf.append(name);
            buf.append('=');
            buf.append(value);
            result[i] = buf.toString();
        }
        return result;
    }

    public void setVarSettings(String[] settings) {
        this.clear();
        int len = settings.length;
        for (int i = 0; i < len; ++i) {
            String setting = settings[i];
            int ndx = setting.indexOf(61);
            String name = setting.substring(0, ndx);
            String value = setting.substring(ndx + 1);
            this.setVarValue(name, value);
        }
    }

    public void clear() {
        this.mVarNames.clear();
        this.mVarTable.clear();
    }

    public int hashCode() {
        return this.mVarTable.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof VariableSettingsHolder)) {
            return false;
        }
        VariableSettingsHolder otherHolder = (VariableSettingsHolder)other;
        return this.mVarTable.equals(otherHolder.mVarTable) && this.mVarNames.equals(otherHolder.mVarNames);
    }

    public boolean equalsVarSource(VariableSettingsSource vars) {
        if (vars == null) {
            return false;
        }
        Object[] names = this.getVarNames();
        if (!Arrays.equals(names, vars.getVarNames())) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (ObjectUtil.equals(this.getVarValue((String)names[i]), vars.getVarValue((String)names[i]))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            VariableSettingsHolder result = (VariableSettingsHolder)super.clone();
            result.mVarTable = (Hashtable)result.mVarTable.clone();
            result.mVarNames = (Vector)result.mVarNames.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void escapeVarValues() {
        Iterator entries = this.mVarTable.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String value = (String)entry.getValue();
            value = ConfigGenerator.escapeVarRefs(value);
            entry.setValue(value);
        }
    }

    void accept(TokenVisitor v) throws Exception {
        String[] varNames = this.getVarNames();
        TokenCallContext tcc = v.getTokenCallContext();
        for (int i = 0; i < varNames.length; ++i) {
            v.visitToken(this.getVarValue(varNames[i]));
            if (!this.mContentsDeclarative) continue;
            tcc.addVarDecl(varNames[i]);
            tcc.addMutableVarDecl(varNames[i]);
        }
    }

    VariableSettingsHolder accept(TokenTransformer t) throws Exception {
        VariableSettingsHolder result = t.clone(this);
        String[] varNames = result.getVarNames();
        TokenCallContext tcc = t.getTokenCallContext();
        for (int i = 0; i < varNames.length; ++i) {
            result.setVarValue(varNames[i], t.transformToken(result.getVarValue(varNames[i])));
            if (!this.mContentsDeclarative) continue;
            tcc.addVarDecl(varNames[i]);
        }
        return result;
    }

    VariableSettingsHolder cloneForTransform() {
        return (VariableSettingsHolder)this.clone();
    }
}

