/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.TopLevelRefTargeter;
import java.io.IOException;
import java.io.Reader;

class TopLevelRefComponentToken
extends InstalledComponentToken {
    private String mRefName;
    private Token mInstallPath;
    private HostRedirectData mTargetRedirect;
    public static final String TOKEN_NAME = "toplevelRef";

    TopLevelRefComponentToken(NestedConfigTemplate template, Reader input) throws IOException, ConfigGenException {
        this.mTargetRedirect = template.readTargetRedirect(input);
        template.readColon(input);
        this.mRefName = template.readIdentifier(input);
        this.mInstallPath = template.readInstallPath(input);
    }

    public String getRefName() {
        return this.mRefName;
    }

    public Token getInstallPath() {
        return this.mInstallPath;
    }

    public HostRedirectData getTargetRedirect() {
        return this.mTargetRedirect;
    }

    public InstalledTarget getTarget(ConfigGenerator generator, TargetedConfigContext cfgCtx, Caller caller, InstallDBContext idbCtx) throws IOException, ConfigGenException, PersistenceManagerException, RPCException {
        this.verifyComponentCaller(caller, false);
        String installPath = this.getInstallPath() == null ? null : this.getInstallPath().toString(generator);
        TopLevelRefTargeter targeter = new TopLevelRefTargeter(this.getRefName(), null, false, installPath, null);
        cfgCtx = this.redirectCurrentHost(this.getTargetRedirect(), generator, cfgCtx);
        return targeter.getInstalledTarget(cfgCtx, caller, idbCtx);
    }

    public void validate(VariableSettingsSource vars, boolean isPrimary, ValidationContext ctx, Caller container) throws ConfigGenException {
        if (isPrimary) {
            ctx.checkPermitted(this);
        }
        if (this.getTargetRedirect() != null) {
            this.getTargetRedirect().validate(vars, ctx, container);
        }
        if (this.getInstallPath() != null) {
            this.getInstallPath().validate(vars, ctx, container);
        }
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(TOKEN_NAME);
        TopLevelRefComponentToken.redirectToStrBuf(this.getTargetRedirect(), buf);
        buf.append(":");
        buf.append(this.getRefName());
        TopLevelRefComponentToken.installPathToStrBuf(this.getInstallPath(), buf);
    }

    protected InstalledComponentToken accept(TokenTransformer t) throws Exception {
        TopLevelRefComponentToken result = (TopLevelRefComponentToken)super.accept(t);
        result.mTargetRedirect = t.transform(result.getTargetRedirect());
        result.mInstallPath = t.transform(result.getInstallPath());
        return result;
    }

    protected void accept(TokenVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargetRedirect());
        v.visit(this.getInstallPath());
    }

    InstalledComponentToken cloneForTransform() {
        if (this.getTargetRedirect() == null && this.getInstallPath() == null) {
            return this;
        }
        return super.cloneForTransform();
    }
}

