/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitor;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitorImpl;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;

public class TokenVisitor
extends ObjectVisitor {
    private boolean mReportErrors = false;
    private TokenCallContext mTokenCallContext = new TokenCallContext(null);

    public TokenVisitor(ObjectVisitorImpl ovi) {
        super(ovi);
        ovi.setTokenVisitor(this);
    }

    public TokenVisitor(ObjectVisitorImpl ovi, boolean reportErrors, Caller caller) {
        this(ovi);
        this.mReportErrors = reportErrors;
        this.mTokenCallContext = new TokenCallContext(caller);
    }

    public boolean reportErrors() {
        return this.mReportErrors;
    }

    public TokenCallContext getTokenCallContext() {
        return this.mTokenCallContext;
    }

    public void visitToken(String s) throws Exception {
        ConfigTemplate.visit(this, s);
    }

    public void visit(ConfigTemplate t) throws Exception {
        t.accept(this);
    }

    void visit(Token t) throws Exception {
        if (t != null) {
            t.accept(this);
        }
    }

    void visit(HostRedirectData d) throws Exception {
        if (d != null) {
            d.accept(this);
        }
    }

    void visit(InstalledComponentToken t) throws Exception {
        t.accept(this);
    }

    public void visit(VariableSettingsHolder h) throws Exception {
        h.accept(this);
    }

    public void visitMutableVar(String inVar) throws ConfigGenException {
        if (this.mReportErrors) {
            this.mTokenCallContext.validateMutableVar(inVar);
        }
    }
}

