/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RetargetStep;
import java.util.HashSet;
import java.util.Stack;

public class TokenCallContext {
    private Stack mVSHStack = new Stack();
    private Caller mCaller = null;
    private static final ValidationContext DEFAULT_CTX = ValidationContext.CONFIG_VALIDATION_CTX;
    private ValidationContext mCtx;
    private Stack mMutableVarsStack = new Stack();

    TokenCallContext(Caller caller) {
        this.mCaller = caller;
        this.mCtx = DEFAULT_CTX;
        this.pushVarScope();
    }

    public void enterComponentVarContext() {
        if (this.mCtx != DEFAULT_CTX) {
            throw new IllegalStateException();
        }
        this.mCtx = ValidationContext.COMP_VAR_CTX;
    }

    public void enterBlockVarContext() {
        if (this.mCtx != DEFAULT_CTX) {
            throw new IllegalStateException();
        }
        this.mCtx = ValidationContext.BLOCK_VAR_CTX;
    }

    public void enterPlanParamContext() {
        if (this.mCtx != DEFAULT_CTX) {
            throw new IllegalStateException();
        }
        this.mCtx = ValidationContext.PLAN_PARAM_CTX;
    }

    public void enterSimplePlanVarContext() {
        if (this.mCtx != DEFAULT_CTX) {
            throw new IllegalStateException();
        }
        this.mCtx = ValidationContext.SIMPLE_PLAN_VAR_CTX;
    }

    public void enterCompositePlanVarContext() {
        if (this.mCtx != DEFAULT_CTX) {
            throw new IllegalStateException();
        }
        this.mCtx = ValidationContext.COMPOSITE_PLAN_VAR_CTX;
    }

    public void enterStepVarContext() {
        if (this.mCaller == null || this.mCaller.getActualComponent() == null) {
            this.enterSimplePlanVarContext();
        } else {
            this.enterBlockVarContext();
        }
    }

    public void exitContext() {
        if (this.mCtx == DEFAULT_CTX) {
            throw new IllegalStateException();
        }
        this.mCtx = DEFAULT_CTX;
    }

    ValidationContext getValidationContext() {
        return this.mCtx;
    }

    VariableSettingsSource getVariableSettingsSource() {
        return (VariableSettingsHolder)this.mVSHStack.peek();
    }

    Caller getCaller() {
        return this.mCaller;
    }

    public void pushVarScope(ExecStep s) {
        VariableSettingsHolder newVars = new VariableSettingsHolder();
        if (this.mVSHStack.size() > 0) {
            VariableSettingsHolder currentScopeVars = (VariableSettingsHolder)this.mVSHStack.peek();
            String[] varNames = currentScopeVars.getVarNames();
            for (int i = 0; i < varNames.length; ++i) {
                String value = currentScopeVars.getVarValue(varNames[i]);
                newVars.setVarValue(varNames[i], value);
            }
        }
        this.mVSHStack.push(newVars);
        this.pushMutableVarScope(s);
    }

    public void pushVarScope() {
        this.pushVarScope(null);
    }

    public void popVarScope() {
        if (this.mVSHStack.size() == 1) {
            throw new IllegalStateException();
        }
        VariableSettingsHolder top = (VariableSettingsHolder)this.mVSHStack.pop();
        this.popMutableVarScope();
    }

    public void addVarDecl(String varName) {
        ((VariableSettingsHolder)this.mVSHStack.peek()).setVarValue(varName, "");
    }

    public void addSystemCompVars() {
        for (int i = 0; i < ComponentConfigManager.SYSTEM_COMP_VARS.length; ++i) {
            this.addVarDecl(ComponentConfigManager.SYSTEM_COMP_VARS[i]);
        }
    }

    private void pushMutableVarScope(ExecStep inStep) {
        HashSet newVars = new HashSet();
        if ((this.mCtx == ValidationContext.SIMPLE_PLAN_VAR_CTX || this.mCtx == ValidationContext.BLOCK_VAR_CTX || inStep != null && inStep instanceof RetargetStep) && this.mMutableVarsStack.size() > 0) {
            HashSet currentMutableScopeVars = (HashSet)this.mMutableVarsStack.peek();
            newVars.addAll(currentMutableScopeVars);
        }
        this.mMutableVarsStack.push(newVars);
    }

    private HashSet popMutableVarScope() {
        if (this.mMutableVarsStack.size() == 1) {
            throw new IllegalStateException();
        }
        HashSet top = (HashSet)this.mMutableVarsStack.pop();
        return top;
    }

    public void addMutableVarDecl(String varName) {
        if (this.mCtx == ValidationContext.BLOCK_VAR_CTX || this.mCtx == ValidationContext.SIMPLE_PLAN_VAR_CTX) {
            this.getMutableVarSet().add(varName);
        }
    }

    private HashSet getMutableVarSet() {
        return (HashSet)this.mMutableVarsStack.peek();
    }

    void validateMutableVar(String inVar) throws ConfigGenException {
        if (inVar != null && !this.getMutableVarSet().contains(inVar)) {
            throw ConfigGenException.mutableVarOutOfScope(inVar);
        }
    }
}

