/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.HostVarToken;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.InstalledComponentVarToken;
import com.raplix.rolloutexpress.config.ProxyTargetedConfigContext;
import com.raplix.rolloutexpress.config.SessionConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import java.io.IOException;
import java.util.Iterator;

class TargetedConfigGenerator
extends ConfigGenerator {
    static final String NAME = "sys.hostName";
    private static final String DESCRIPTION = "sys.description";
    private static final String HOSTTYPE_NAME = "sys.hostType";
    private static final String RA_IP = "sys.ipAddress";
    private static final String RA_PORT = "sys.portNumber";
    private static final String RA_HOME_DIR = "sys.raHomeDir";
    private static final String RA_DATA_DIR = "sys.raDataDir";
    private static final String RA_CONFIG_DIR = "sys.raConfigDir";
    private static final String RA_TMP_DIR = "sys.raTmpDir";
    private static final String RA_OS_NAME = "sys.OSName";
    private static final String RA_OS_VERSION = "sys.OSVersion";
    private static final String RA_OS_ARCH = "sys.OSArch";
    private static final String RA_PATH_SEPARATOR = ":";
    private static final String RA_FILE_SEPARATOR = "/";
    private static final String[] HOST_PREDEF_NAMES = new String[]{"sys.hostName", "sys.description", "sys.hostType", "sys.ipAddress", "sys.portNumber", "sys.raHomeDir", "sys.raDataDir", "sys.raConfigDir", "sys.raTmpDir", "sys.OSName", "sys.OSVersion", "sys.OSArch"};
    private TargetedConfigContext mTargetContext;
    private InstallDBContext mInstallDBContext;

    private InstallDBContext getInstallDBContext() {
        return this.mInstallDBContext;
    }

    TargetedConfigGenerator(ConfigGenerator parentScope, TargetedConfigContext targetContext, InstallDBContext installDBContext) {
        super(parentScope);
        this.mTargetContext = targetContext;
        this.mInstallDBContext = installDBContext;
    }

    private TargetedConfigContext getTargetContext() {
        return this.mTargetContext;
    }

    String resolveLocal(HostVarToken token, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        String varName = token.getVarName();
        Host target = this.resolveHost(token.getTargetRedirect(), callbackScope);
        return this.resolveTargetVar(target, varName);
    }

    private Host resolveHost(HostRedirectData targetRedirect, ConfigGenerator callbackScope) throws ConfigGenException, IOException {
        try {
            return this.getTargetContext().resolveHost(targetRedirect, callbackScope);
        }
        catch (PersistenceManagerException e) {
            throw new ConfigGenException(e);
        }
        catch (RPCException e) {
            throw new ConfigGenException(e);
        }
    }

    private String resolveTargetVar(Host host, String var) throws ConfigGenException {
        if (var.equals(NAME)) {
            return TargetedConfigGenerator.toStr(host.getName());
        }
        if (var.equals(DESCRIPTION)) {
            return TargetedConfigGenerator.toStr(host.getDescription());
        }
        if (var.equals(HOSTTYPE_NAME)) {
            return TargetedConfigGenerator.toStr(host.getHostType().getName());
        }
        if (var.equals(RA_IP)) {
            return TargetedConfigGenerator.toStr(this.getAppRA(host, var).getIPAddress());
        }
        if (var.equals(RA_PORT)) {
            return TargetedConfigGenerator.toStr(String.valueOf(this.getAppRA(host, var).getPort()));
        }
        if (var.equals(RA_HOME_DIR)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getRAHomeDir());
        }
        if (var.equals(RA_DATA_DIR)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getRADataDir());
        }
        if (var.equals(RA_CONFIG_DIR)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getRAConfigDir());
        }
        if (var.equals(RA_TMP_DIR)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getRATmpDir());
        }
        if (var.equals(RA_OS_NAME)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getOSName());
        }
        if (var.equals(RA_OS_VERSION)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getOSVersion());
        }
        if (var.equals(RA_OS_ARCH)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getOSArch());
        }
        if (var.equals(RA_PATH_SEPARATOR)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getRAPathSeparator());
        }
        if (var.equals(RA_FILE_SEPARATOR)) {
            return TargetedConfigGenerator.toStr(this.getMachineInfo(host, var).getRAFileSeparator());
        }
        String value = host.getVarValue(var);
        if (value == null) {
            return null;
        }
        for (ConfigGenerator gen = this.getParentScope(); gen != null; gen = gen.getParentScope()) {
            if (gen instanceof SessionConfigGenerator) {
                return gen.generateNested(value);
            }
            if (gen.getParentScope() != null) continue;
            return gen.generateNested(value);
        }
        return value;
    }

    private AppInstance getAppRA(Host h, String var) throws ConfigGenException {
        AppInstance ra = h.getAppRA();
        if (ra == null) {
            throw ConfigGenException.noRAOnHostError(h, var);
        }
        return ra;
    }

    private MachineInfo getMachineInfo(Host h, String var) throws ConfigGenException {
        MachineInfo mi = h.getMachineInfo();
        if (mi == null) {
            throw ConfigGenException.noMachineInfoOnHostError(h.getName(), var);
        }
        return mi;
    }

    MachineInfo getMachineInfo(String varName) throws ConfigGenException {
        try {
            TargetedConfigContext cfgCtx = this.getTargetContext();
            Host h = cfgCtx.getTargetHost();
            h = cfgCtx.getRootHost(h);
            return this.getMachineInfo(h, varName);
        }
        catch (PersistenceManagerException e) {
            throw new ConfigGenException(e);
        }
        catch (RPCException e) {
            throw new ConfigGenException(e);
        }
    }

    String resolveLocal(InstalledComponentVarToken token, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        try {
            if (caller == null || caller.getDeclaredPath() == null) {
                throw ConfigGenException.noCallerScope();
            }
            Caller curCaller = caller;
            Iterator instCompTokens = token.getInstalledComponentTokenList();
            InstallDBContext idbCtx = this.getInstallDBContext();
            InstalledTarget target = null;
            ProxyTargetedConfigContext cfgCtx = new ProxyTargetedConfigContext(this.getTargetContext());
            while (true) {
                InstalledComponentToken ict = (InstalledComponentToken)instCompTokens.next();
                target = ict.getTarget(callbackScope, cfgCtx, curCaller, idbCtx);
                CallSpec cs = target.getCallSpec();
                cs = new CallSpec(caller, cs.getCalleeType());
                if (!target.getActualComponent().isAccessible(cs)) {
                    throw ConfigGenException.noAccessToComp(ict);
                }
                if (!instCompTokens.hasNext()) break;
                curCaller = target.getCallerForMember(null);
                cfgCtx.setTargetHost(target.getHost());
            }
            return this.getInstalledVar(target, token, caller);
        }
        catch (PersistenceManagerException e) {
            throw ConfigGenException.noSuchObjectError(token, e);
        }
        catch (RPCException e) {
            throw new ConfigGenException(e);
        }
    }

    private String getInstalledVar(InstalledTarget target, InstalledComponentVarToken token, Caller caller) throws ConfigGenException, PersistenceManagerException, RPCException {
        InstalledComponent instComp = target.getInstalledComponent();
        Component comp = target.getActualComponent();
        String varName = token.getVarName();
        if (!ComponentConfigManager.isPredefName(varName)) {
            CallSpec callSpec = target.getCallSpec();
            if (comp.resolveVar(varName, callSpec = new CallSpec(caller, callSpec.getCalleeType())) == null) {
                throw ConfigGenException.unknownCompVar(token);
            }
        }
        GeneratedVariableSettings genVars = this.getContext().getVarManager().getVariableSettings(instComp.getVariableSettingsID());
        VariableSettingsSource compVars = ComponentConfigManager.getComponentVars(genVars, comp);
        return compVars.getVarValue(varName);
    }

    static boolean isPredefName(String name) {
        return TargetedConfigGenerator.containsName(HOST_PREDEF_NAMES, name);
    }

    private static boolean containsName(String[] names, String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return true;
        }
        return false;
    }
}

