/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.HostVarToken;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;

public class TargetedConfigContext {
    private Hashtable mIDMap = new Hashtable();
    private Hashtable mNameMap = new Hashtable();
    private Host mTargetHost;

    public TargetedConfigContext(Host targetHost) {
        this.addHost(targetHost);
        this.mTargetHost = targetHost;
    }

    public Host getHost(HostID hostID) throws PersistenceManagerException, RPCException {
        Host result = (Host)this.mIDMap.get(hostID);
        if (result == null) {
            result = hostID.getByIDQuery().select();
            this.addHost(result);
        }
        return (Host)result.clone();
    }

    public Host getHost(String hostName) throws PersistenceManagerException, RPCException {
        Host result = (Host)this.mNameMap.get(hostName);
        if (result == null) {
            result = SingleHostQuery.byName(hostName).select();
            this.addHost(result);
        }
        return (Host)result.clone();
    }

    public Host resolveHost(String hostRef) throws PersistenceManagerException, RPCException, ConfigGenException {
        if (hostRef == null) {
            return this.getTargetHost();
        }
        try {
            int bufLen = hostRef.length() + 9 + "target".length();
            StringBuffer buf = new StringBuffer(bufLen);
            buf.append(":[");
            buf.append("target");
            buf.append("(");
            buf.append(hostRef);
            buf.append("):var]");
            NestedConfigTemplate template = new NestedConfigTemplate(new StringReader(buf.toString()));
            HostVarToken hostVar = (HostVarToken)template.getFirstToken();
            HostRedirectData hostToken = hostVar.getTargetRedirect();
            return this.resolveHost(hostToken, ConfigGenerator.NO_OP_GENERATOR);
        }
        catch (ConfigGenException e) {
            throw ConfigGenException.invalidHostRef(hostRef, e);
        }
        catch (IOException e) {
            throw ConfigGenException.ioError(e);
        }
    }

    Host resolveHost(HostRedirectData targetRedirect, ConfigGenerator callbackScope) throws PersistenceManagerException, RPCException, ConfigGenException, IOException {
        Host target;
        if (targetRedirect == null) {
            target = this.getTargetHost();
        } else {
            Token targetNameToken = targetRedirect.getTargetName();
            if (targetNameToken != null) {
                String hostName = targetNameToken.toString(callbackScope);
                target = this.getHost(hostName);
            } else {
                target = this.getTargetHost();
            }
            if (targetRedirect.isRootRedirect()) {
                target = this.getRootHost(target);
            } else {
                HostID parentID;
                for (int numParents = targetRedirect.getNumParentRedirects(); numParents > 0 && (parentID = target.getParentHostID()) != null; --numParents) {
                    target = this.getHost(parentID);
                }
            }
        }
        return target;
    }

    Host getRootHost(Host target) throws PersistenceManagerException, RPCException {
        HostID parentID;
        while ((parentID = target.getParentHostID()) != null) {
            target = this.getHost(parentID);
        }
        return target;
    }

    public Host getTargetHost() {
        return (Host)this.mTargetHost.clone();
    }

    private void addHost(Host host) {
        this.mIDMap.put(host.getID(), host);
        this.mNameMap.put(host.getName(), host);
    }
}

