/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetableComponentTargeter;
import java.io.IOException;
import java.io.Reader;

class TargetableComponentToken
extends InstalledComponentToken {
    private HostRedirectData mTargetRedirect;
    public static final String TOKEN_NAME = "targetableComponent";

    TargetableComponentToken(NestedConfigTemplate template, Reader input) throws IOException, ConfigGenException {
        this.mTargetRedirect = template.readTargetRedirect(input);
    }

    public HostRedirectData getTargetRedirect() {
        return this.mTargetRedirect;
    }

    public InstalledTarget getTarget(ConfigGenerator generator, TargetedConfigContext cfgCtx, Caller caller, InstallDBContext idbCtx) throws IOException, ConfigGenException, PersistenceManagerException, RPCException {
        cfgCtx = this.redirectCurrentHost(this.getTargetRedirect(), generator, cfgCtx);
        TargetableComponentTargeter targeter = new TargetableComponentTargeter(null);
        return targeter.getInstalledTarget(cfgCtx, caller, idbCtx);
    }

    public void validate(VariableSettingsSource vars, boolean isPrimary, ValidationContext ctx, Caller container) throws ConfigGenException {
        if (isPrimary) {
            ctx.checkPermitted(this);
        }
        if (this.getTargetRedirect() != null) {
            this.getTargetRedirect().validate(vars, ctx, container);
        }
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(TOKEN_NAME);
        TargetableComponentToken.redirectToStrBuf(this.getTargetRedirect(), buf);
    }

    protected InstalledComponentToken accept(TokenTransformer t) throws Exception {
        TargetableComponentToken result = (TargetableComponentToken)super.accept(t);
        result.mTargetRedirect = t.transform(result.getTargetRedirect());
        return result;
    }

    protected void accept(TokenVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargetRedirect());
    }

    InstalledComponentToken cloneForTransform() {
        if (this.getTargetRedirect() == null) {
            return this;
        }
        return super.cloneForTransform();
    }
}

