/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.NameMapper;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.TokenPluginNSValidator;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.SystemServiceTargeter;
import java.io.IOException;
import java.io.Reader;

class SystemServiceComponentToken
extends InstalledComponentToken {
    private String mServiceName;
    public static final String TOKEN_NAME = "systemService";

    SystemServiceComponentToken(NestedConfigTemplate template, Reader input) throws IOException, ConfigGenException {
        template.readColon(input);
        this.mServiceName = template.readSystemName(input);
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public InstalledTarget getTarget(ConfigGenerator generator, TargetedConfigContext cfgCtx, Caller caller, InstallDBContext idbCtx) throws IOException, ConfigGenException, PersistenceManagerException, RPCException {
        SystemServiceTargeter targeter = new SystemServiceTargeter(this.getServiceName());
        return targeter.getInstalledTarget(cfgCtx, caller, idbCtx);
    }

    public void validate(VariableSettingsSource vars, boolean isPrimary, ValidationContext ctx, Caller container) throws ConfigGenException {
        if (isPrimary) {
            ctx.checkPermitted(this);
        }
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(TOKEN_NAME);
        buf.append(":");
        buf.append(this.getServiceName());
    }

    InstalledComponentToken cloneForTransform() {
        return this;
    }

    InstalledComponentToken cloneForMapNames() {
        return super.cloneForTransform();
    }

    public InstalledComponentToken mapNames(NameMapper mapper) {
        SystemServiceComponentToken result = (SystemServiceComponentToken)super.mapNames(mapper);
        result.mServiceName = mapper.getNameMap().mapSystemService(this.getServiceName());
        return result;
    }

    void validateNamespace(TokenPluginNSValidator v) throws Exception {
        super.validateNamespace(v);
        SystemServiceRef ssr = SingleSystemServiceRefQuery.byName(this.getServiceName()).select();
        v.getPlugin().validateNamespace(ssr.getPluginID(), this.getServiceName(), TOKEN_NAME);
    }
}

