/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.NameMapper;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import java.io.IOException;

class SimpleVarToken
extends Token {
    private String mVarName;

    public SimpleVarToken(String varName) {
        this.mVarName = varName;
    }

    public String getVarName() {
        return this.mVarName;
    }

    String resolveLocal(ConfigGenerator generator, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        return generator.resolveLocal(this, callbackScope, caller);
    }

    public void validate(VariableSettingsSource vars, ValidationContext ctx, Caller container) throws ConfigGenException {
        ctx.checkPermitted(this);
        if (!vars.containsVarValue(this.getVarName())) {
            throw ConfigGenException.undefinedVar(this.toString());
        }
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(":[");
        buf.append(this.getVarName());
        buf.append("]");
    }

    Token cloneForTransform() {
        return this;
    }

    Token cloneForMapNames() {
        return super.cloneForTransform();
    }

    public Token mapNames(NameMapper mapper) {
        SimpleVarToken result = (SimpleVarToken)super.mapNames(mapper);
        result.mVarName = mapper.getNameMap().mapSimpleCompVar(this.getVarName());
        return result;
    }
}

