/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.HostVarToken;
import com.raplix.rolloutexpress.config.SessionVarToken;
import com.raplix.rolloutexpress.config.UnresolvedSessionVarException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SingleSessionVarDescriptorQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import java.io.IOException;

class SessionConfigGenerator
extends ConfigGenerator {
    private static final String SESSION_ID_VARNAME = "sys:sessionID";
    private static final HostVarToken CURRENT_HOST_NAME_TOKEN = new HostVarToken("sys.hostName", null);
    private SessionVariableSet mSessionVariables;
    private SessionID mSessionID;
    private SessionManager mSessionManager;
    private boolean mHideSecureVariables;

    SessionConfigGenerator(ConfigGenerator parentScope, SessionManager sessionManager, boolean hideSecureVariables) throws ConfigGenException {
        super(parentScope);
        this.mSessionManager = sessionManager;
        this.mHideSecureVariables = hideSecureVariables;
        try {
            this.mSessionVariables = this.mSessionManager.getSessionVariables();
            this.mSessionID = this.mSessionManager.getCurrentSessionID();
        }
        catch (UserDBException e) {
            throw new ConfigGenException(e);
        }
        catch (RPCException e) {
            throw new ConfigGenException(e);
        }
    }

    String resolveLocal(SessionVarToken token, ConfigGenerator callbackGenerator, Caller caller) throws ConfigGenException, IOException {
        SessionVariable var;
        String varName = token.getVarName();
        if (SESSION_ID_VARNAME.equals(varName)) {
            return this.resolveSessionID(callbackGenerator);
        }
        if (this.mSessionVariables != null && (var = this.mSessionVariables.getVariable(varName)) != null) {
            if (this.mHideSecureVariables && var.getSecure()) {
                return "*****";
            }
            return var.getValue();
        }
        throw this.unresolvedSessionVar(varName);
    }

    private String resolveSessionID(ConfigGenerator callbackGenerator) throws ConfigGenException, IOException {
        if (this.mSessionID != null) {
            String currentHostName = this.getCurrentHostName(callbackGenerator);
            ConfigGenSubsystem subsys = ConfigGenSubsystem.getInstance();
            if (subsys == null) {
                throw ConfigGenException.noMSForSessionID();
            }
            if (!subsys.allowSessionIDOnHost(currentHostName)) {
                throw ConfigGenException.sessionIDNotAllowedOnHost(currentHostName);
            }
            if (this.mHideSecureVariables) {
                return "*****";
            }
            return this.mSessionID.toString();
        }
        throw ConfigGenException.noSessionID();
    }

    private String getCurrentHostName(ConfigGenerator gen) throws ConfigGenException, IOException {
        try {
            return CURRENT_HOST_NAME_TOKEN.toString(gen);
        }
        catch (ConfigGenException e) {
            throw ConfigGenException.noHostForSessionID();
        }
    }

    private UnresolvedSessionVarException unresolvedSessionVar(String varName) {
        SummarySessionVarDescriptor desc = null;
        try {
            SingleSessionVarDescriptorQuery query = SingleSessionVarDescriptorQuery.byName(varName);
            desc = query.selectSummaryView();
        }
        catch (PersistenceManagerException ignored) {
        }
        catch (RPCException ignored) {
            // empty catch block
        }
        if (desc == null) {
            SessionVarDescriptor descriptor = new SessionVarDescriptor(varName);
            descriptor.setDescription(new ROXMessage("config.UNRES_SESSION_VAR_DESCRIPTION", varName).toString());
            descriptor.setSecure(true);
            try {
                descriptor.save();
                desc = descriptor;
            }
            catch (RPCException ignored) {
            }
            catch (PersistenceManagerException ignored) {
            }
            catch (UserDBException ignored) {
                // empty catch block
            }
        }
        try {
            SessionVariableSet set = this.mSessionManager.getSessionVariables();
            if (set != null && !set.contains(varName)) {
                set.add(new SessionVariable(varName, "", desc == null ? true : desc.getSecure()));
                this.mSessionManager.setSessionVariables(set);
            }
        }
        catch (UserDBException ignored) {
        }
        catch (RPCException ignored) {
            // empty catch block
        }
        ROXMessage addVarMsg = new ROXMessage("config.UNRES_SESSION_VAR_ADDVAR");
        ROXMessage editVarMsg = new ROXMessage("config.UNRES_SESSION_VAR_EDITVAR");
        ROXMessage msg = new ROXMessage("config.UNRES_SESSION_VAR", new Object[]{varName, desc != null ? desc.getDescription() : "", desc == null ? addVarMsg : editVarMsg});
        return new UnresolvedSessionVarException(msg, varName);
    }

    static boolean isPredefName(String predef) {
        return SESSION_ID_VARNAME.equals(predef);
    }
}

