/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectHasNoIDQueryException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotRetrievedQueryException;

public class PersistentVariableSettings
extends PersistentObject
implements RPCSerializable {
    private VariableSettingsHolder mVars = new VariableSettingsHolder();
    private String mName;

    public PersistentVariableSettings() {
    }

    PersistentVariableSettings(String name, VariableSettingsSource other) {
        this.setName(name);
        this.updateVariables(other);
    }

    PersistentVariableSettings(GeneratedVariableSettingsID ID2) throws ConfigGenException {
        try {
            this.setObjectID(ID2);
            this.retrieve();
        }
        catch (ObjectNotRetrievedQueryException e) {
            throw ConfigGenException.noSuchObjectError(e);
        }
        catch (ObjectHasNoIDQueryException e) {
            throw ConfigGenException.noSuchObjectError(e);
        }
        catch (PersistenceManagerException e) {
            throw ConfigGenException.retrieveError(e);
        }
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getVarValue(String varName) {
        return this.mVars.getVarValue(varName);
    }

    public String[] getVarNames() {
        return this.mVars.getVarNames();
    }

    public boolean containsVarValue(String varName) {
        return this.mVars.containsVarValue(varName);
    }

    private String[] getVarSettings() {
        return this.mVars.getVarSettings();
    }

    private void setVarSettings(String[] settings) {
        this.mVars.setVarSettings(settings);
    }

    void updateVariables(VariableSettingsSource source) {
        this.mVars.clear();
        String[] names = source.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            this.mVars.setVarValue(names[i], source.getVarValue(names[i]));
        }
    }

    public boolean equalsData(PersistentVariableSettings other) {
        if (other == null) {
            return false;
        }
        return this.equals(this.getName(), other.getName()) && this.mVars.equals(other.mVars);
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

