/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.HostVarToken;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.InstalledComponentVarToken;
import com.raplix.rolloutexpress.config.SessionConfigGenerator;
import com.raplix.rolloutexpress.config.SessionVarToken;
import com.raplix.rolloutexpress.config.TextToken;
import com.raplix.rolloutexpress.config.Token;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

class NestedConfigTemplate
extends ConfigTemplate {
    static final String HOST_TAG = "target";
    static final String SESSION_TAG = "session";
    static final char PATH_SEPARATOR_TAG = ':';
    static final char FILE_SEPARATOR_TAG = '/';
    static final char PLUGIN_SEPARATOR_TAG = '#';
    private static final String HOST_NAME_EXTRA = "-. ";
    private static final String ENTITY_NAME_EXTRA = "-. ";
    private static final String SYSTEM_NAME_EXTRA = "-. +";
    private static final String SESSION_NAME_EXTRA = "-.";

    NestedConfigTemplate(Reader source) throws ConfigGenException, IOException {
        super(source);
    }

    Token getVarToken(String varName, Reader input) throws IOException, ConfigGenException {
        if (this.peek(input) != 93) {
            if (HOST_TAG.equals(varName)) {
                return this.readHostVar(input);
            }
            if (SESSION_TAG.equals(varName)) {
                return this.readSessionVar(input);
            }
            InstalledComponentVarToken result = this.readInstalledComponentVar(varName, input);
            if (result != null) {
                return result;
            }
        }
        return super.getVarToken(varName, input);
    }

    Token readVar(Reader input) throws IOException, ConfigGenException {
        input.mark(1);
        int ch = input.read();
        if (this.isPathOrFileSeparator(ch)) {
            HostVarToken result = this.readPathOrFileSeparatorVar((char)ch, input);
            this.readChar(']', input);
            return result;
        }
        input.reset();
        return super.readVar(input);
    }

    boolean isPathOrFileSeparator(int ch) {
        return ch == 58 || ch == 47;
    }

    HostVarToken readHostVar(Reader input) throws IOException, ConfigGenException {
        HostRedirectData targetRedirect = this.readTargetRedirect(input);
        this.readColon(input);
        String varName = this.readIdentifier(input, false);
        return new HostVarToken(varName, targetRedirect);
    }

    HostRedirectData readTargetRedirect(Reader input) throws IOException, ConfigGenException {
        input.mark(1);
        int ch = input.read();
        switch (ch) {
            case 40: {
                HostRedirectData result;
                input.mark(1);
                ch = input.read();
                switch (ch) {
                    case 46: 
                    case 47: {
                        input.reset();
                        result = new HostRedirectData(null);
                        this.readParentRedirect(input, result);
                        break;
                    }
                    default: {
                        input.reset();
                        result = new HostRedirectData(this.readHostNameOrVar(input));
                        input.mark(1);
                        if (input.read() == 47) {
                            this.readParentRedirect(input, result);
                            break;
                        }
                        input.reset();
                    }
                }
                this.readChar(')', input);
                return result;
            }
        }
        input.reset();
        return null;
    }

    Token readHostNameOrVar(Reader input) throws IOException, ConfigGenException {
        input.mark(1);
        int ch = input.read();
        switch (ch) {
            case 58: {
                this.readChar('[', input);
                return this.readVar(input);
            }
        }
        input.reset();
        return new TextToken(this.readHostName(input));
    }

    private void readParentRedirect(Reader input, HostRedirectData redirect) throws IOException, ConfigGenException {
        int ch = input.read();
        switch (ch) {
            case 47: {
                redirect.setRootRedirect(true);
                return;
            }
            case 46: {
                while (true) {
                    this.readChar('.', input);
                    redirect.addParentRedirect();
                    input.mark(1);
                    if (input.read() != 47) break;
                    this.readChar('.', input);
                }
                input.reset();
                return;
            }
        }
        throw ConfigGenException.invalidVarRef();
    }

    InstalledComponentVarToken readInstalledComponentVar(String name, Reader input) throws IOException, ConfigGenException {
        InstalledComponentToken ict = InstalledComponentToken.readPrimary(name, this, input);
        if (ict == null) {
            return null;
        }
        ArrayList<InstalledComponentToken> instCompTokens = new ArrayList<InstalledComponentToken>();
        while (ict != null) {
            instCompTokens.add(ict);
            this.readColon(input);
            name = this.readIdentifier(input, true);
            if (this.peek(input) == 93) {
                ict = null;
                continue;
            }
            ict = InstalledComponentToken.readSecondary(name, this, input);
        }
        return new InstalledComponentVarToken(instCompTokens, name);
    }

    SessionVarToken readSessionVar(Reader input) throws IOException, ConfigGenException {
        this.readColon(input);
        return new SessionVarToken(this.readSessionVarName(input));
    }

    HostVarToken readPathOrFileSeparatorVar(char varName, Reader input) {
        return new HostVarToken(varName);
    }

    Token readInstallPath(Reader input) throws IOException, ConfigGenException {
        Token path = null;
        input.mark(1);
        if (input.read() == 64) {
            this.readChar('{', input);
            input.mark(1);
            int ch = input.read();
            switch (ch) {
                case 58: {
                    this.readChar('[', input);
                    path = this.readVar(input);
                    this.readChar('}', input);
                    break;
                }
                default: {
                    input.reset();
                    path = new TextToken(this.readInstallPathLiteral(input));
                    break;
                }
            }
        } else {
            input.reset();
        }
        return path;
    }

    private String readInstallPathLiteral(Reader input) throws IOException, ConfigGenException {
        StringBuffer path = new StringBuffer();
        boolean done = false;
        block4: while (!done) {
            int ch = input.read();
            switch (ch) {
                case -1: {
                    throw ConfigGenException.invalidVarRef();
                }
                case 125: {
                    input.mark(1);
                    ch = input.read();
                    if (ch == 125) break;
                    input.reset();
                    done = true;
                    continue block4;
                }
            }
            path.append((char)ch);
        }
        if (path.length() == 0) {
            throw ConfigGenException.invalidVarRef();
        }
        return path.toString();
    }

    int readFullName(Reader input, StringBuffer result) throws IOException, ConfigGenException {
        int ch = this.peek(input);
        if (ch == 47) {
            input.read();
            result.append((char)ch);
        }
        while (true) {
            int nameStart = result.length();
            this.readEntityName(input, result);
            if (this.peek(input) != 47) {
                String namePart = result.substring(nameStart);
                if (".".equals(namePart) || "..".equals(namePart)) {
                    throw ConfigGenException.invalidVarRef();
                }
                return nameStart;
            }
            this.readChar('/', input);
            result.append('/');
        }
    }

    String readHostName(Reader input) throws IOException, ConfigGenException {
        StringBuffer result = new StringBuffer();
        this.readIdentifier(input, "-. ", result);
        return result.toString();
    }

    private void readEntityName(Reader input, StringBuffer result) throws IOException, ConfigGenException {
        int ch = input.read();
        if (!this.isEntityNameChar(ch)) {
            throw ConfigGenException.invalidVarRef();
        }
        result.append((char)ch);
        while (true) {
            input.mark(1);
            ch = input.read();
            if (!this.isEntityNameChar(ch)) break;
            result.append((char)ch);
        }
        input.reset();
    }

    private boolean isEntityNameChar(int ch) {
        return this.isIdentifierChar(ch) || "-. ".indexOf(ch) != -1;
    }

    String readSystemName(Reader input) throws IOException, ConfigGenException {
        StringBuffer result = new StringBuffer();
        this.readIdentifier(input, SYSTEM_NAME_EXTRA, result);
        if (this.peek(input) == 35) {
            String name = result.toString();
            String lastChar = name.substring(name.length() - 1);
            if (name.indexOf(45) != -1 || name.indexOf(32) != -1 || name.indexOf(43) != -1 || name.indexOf("..") != -1 || lastChar.equals(".")) {
                throw ConfigGenException.invalidVarRef();
            }
            result.append((char)input.read());
            this.readIdentifier(input, SYSTEM_NAME_EXTRA, result);
        }
        return result.toString();
    }

    String readSessionVarName(Reader input) throws IOException, ConfigGenException {
        StringBuffer result = new StringBuffer();
        this.readIdentifier(input, SESSION_NAME_EXTRA, result);
        if (result.toString().equals("sys") && this.peek(input) == 58) {
            result.append((char)input.read());
            this.readIdentifier(input, SESSION_NAME_EXTRA, result);
            String predef = result.toString();
            if (!SessionConfigGenerator.isPredefName(predef)) {
                throw ConfigGenException.invalidPredefSessionVar(predef);
            }
        }
        return result.toString();
    }

    String readVersion(Reader input) throws IOException, ConfigGenException {
        input.mark(1);
        if (input.read() == 35) {
            StringBuffer version = new StringBuffer();
            int ch = input.read();
            if (!this.isAsciiDigitChar(ch) || ch == 48) {
                throw ConfigGenException.invalidVarRef();
            }
            version.append((char)ch);
            while ((ch = input.read()) != 46) {
                if (this.isAsciiDigitChar(ch)) {
                    version.append((char)ch);
                    continue;
                }
                throw ConfigGenException.invalidVarRef();
            }
            version.append('.');
            ch = input.read();
            if (!this.isAsciiDigitChar(ch)) {
                throw ConfigGenException.invalidVarRef();
            }
            version.append((char)ch);
            while (true) {
                input.mark(1);
                ch = input.read();
                if (!this.isAsciiDigitChar(ch)) break;
                version.append((char)ch);
            }
            input.reset();
            return version.toString();
        }
        input.reset();
        return null;
    }

    void readColon(Reader input) throws IOException, ConfigGenException {
        this.readChar(':', input);
    }
}

