/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.SimpleVarToken;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import java.io.IOException;

class LocalConfigGenerator
extends ConfigGenerator {
    private VariableSettingsHolder mLocalVars;
    private boolean mIsMutable;

    LocalConfigGenerator(ConfigGenerator parentScope, VariableSettingsHolder localVars, boolean inMutable) {
        super(parentScope);
        this.mLocalVars = localVars;
        this.mIsMutable = inMutable;
    }

    LocalConfigGenerator(ConfigGenerator parentScope, VariableSettingsSource localVars, boolean inMutable) throws ConfigGenException {
        super(parentScope);
        VariableSettingsHolder resVars;
        this.mLocalVars = resVars = new VariableSettingsHolder();
        String[] names = localVars.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            String resValue = this.generateNested(localVars.getVarValue(names[i]));
            resVars.setVarValue(names[i], resValue);
        }
        this.mIsMutable = inMutable;
    }

    private boolean isMutable() {
        return this.mIsMutable;
    }

    private VariableSettingsHolder getLocalVars() {
        return this.mLocalVars;
    }

    String resolveLocal(SimpleVarToken token, ConfigGenerator callbackScope, Caller caller) {
        return this.getLocalVars().getVarValue(token.getVarName());
    }

    public void setVarValue(String inName, String inValue) throws ConfigGenException, IOException {
        if (!this.isMutable()) {
            throw ConfigGenException.variableAssignationNotAllowed(inName);
        }
        VariableSettingsHolder vars = this.getLocalVars();
        if (vars.containsVarValue(inName)) {
            vars.setVarValue(inName, inValue);
        } else {
            super.setVarValue(inName, inValue);
        }
    }
}

