/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.NameMapper;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class InstalledComponentVarToken
extends Token {
    private List mInstCompTokenList;
    private String mVarName;

    public InstalledComponentVarToken(List instCompTokenList, String varName) {
        this.mInstCompTokenList = Collections.unmodifiableList(instCompTokenList);
        this.mVarName = varName;
    }

    public Iterator getInstalledComponentTokenList() {
        return this.mInstCompTokenList.iterator();
    }

    public String getVarName() {
        return this.mVarName;
    }

    String resolveLocal(ConfigGenerator generator, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        return generator.resolveLocal(this, callbackScope, caller);
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(":[");
        Iterator instCompTokens = this.getInstalledComponentTokenList();
        while (instCompTokens.hasNext()) {
            InstalledComponentToken ict = (InstalledComponentToken)instCompTokens.next();
            ict.toStringBuffer(buf);
            buf.append(":");
        }
        buf.append(this.getVarName());
        buf.append("]");
    }

    public void validate(VariableSettingsSource vars, ValidationContext ctx, Caller container) throws ConfigGenException {
        ctx.checkPermitted(this);
        Iterator instCompTokens = this.getInstalledComponentTokenList();
        boolean isPrimary = true;
        while (instCompTokens.hasNext()) {
            InstalledComponentToken ict = (InstalledComponentToken)instCompTokens.next();
            ict.validate(vars, isPrimary, ctx, container);
            isPrimary = false;
        }
    }

    protected Token accept(TokenTransformer t) throws Exception {
        InstalledComponentVarToken result = (InstalledComponentVarToken)super.accept(t);
        Iterator iter = result.getInstalledComponentTokenList();
        ArrayList<InstalledComponentToken> tokens = new ArrayList<InstalledComponentToken>();
        while (iter.hasNext()) {
            InstalledComponentToken ict = (InstalledComponentToken)iter.next();
            tokens.add(t.transform(ict));
        }
        result.mInstCompTokenList = Collections.unmodifiableList(tokens);
        return result;
    }

    protected void accept(TokenVisitor v) throws Exception {
        super.accept(v);
        Iterator iter = this.getInstalledComponentTokenList();
        while (iter.hasNext()) {
            InstalledComponentToken ict = (InstalledComponentToken)iter.next();
            v.visit(ict);
        }
    }

    public Token mapNames(NameMapper mapper) {
        InstalledComponentVarToken result = (InstalledComponentVarToken)super.mapNames(mapper);
        result.mVarName = mapper.getNameMap().mapCompVar(this.mVarName);
        return result;
    }
}

