/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.ContainerComponentToken;
import com.raplix.rolloutexpress.config.DefaultComponentToken;
import com.raplix.rolloutexpress.config.DependeeComponentToken;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.NameMapper;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import com.raplix.rolloutexpress.config.NestedRefComponentToken;
import com.raplix.rolloutexpress.config.ProxyTargetedConfigContext;
import com.raplix.rolloutexpress.config.SystemServiceComponentToken;
import com.raplix.rolloutexpress.config.SystemTypeComponentToken;
import com.raplix.rolloutexpress.config.TargetableComponentToken;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.TextToken;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenPluginNSValidator;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.TopLevelRefComponentToken;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.util.reflect.ConstructorUtil;
import com.raplix.util.reflect.FieldUtil;
import com.raplix.util.string.Replace;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;

abstract class InstalledComponentToken
implements Cloneable {
    private static final HashMap PRIMARY_TOKENS = new HashMap();
    private static final HashMap SECONDARY_TOKENS;

    InstalledComponentToken() {
    }

    public abstract InstalledTarget getTarget(ConfigGenerator var1, TargetedConfigContext var2, Caller var3, InstallDBContext var4) throws IOException, ConfigGenException, PersistenceManagerException, RPCException;

    public abstract void validate(VariableSettingsSource var1, boolean var2, ValidationContext var3, Caller var4) throws ConfigGenException;

    protected void verifyComponentCaller(Caller caller, boolean installedRequired) throws ConfigGenException {
        if (installedRequired && caller.getInstalledComponent() == null || caller.getActualComponent() == null || caller.getDeclaredComponent() == null) {
            throw ConfigGenException.nonComponentCaller(this);
        }
    }

    protected TargetedConfigContext redirectCurrentHost(HostRedirectData hostRedirect, ConfigGenerator generator, TargetedConfigContext cfgCtx) throws IOException, ConfigGenException, PersistenceManagerException, RPCException {
        if (hostRedirect != null) {
            ProxyTargetedConfigContext result = new ProxyTargetedConfigContext(cfgCtx);
            result.setTargetHost(result.resolveHost(hostRedirect, generator));
            cfgCtx = result;
        }
        return cfgCtx;
    }

    protected static void redirectToStrBuf(HostRedirectData redirect, StringBuffer buf) {
        if (redirect != null) {
            redirect.toStringBuffer(buf);
        }
    }

    protected static void installPathToStrBuf(Token installPathToken, StringBuffer buf) {
        if (installPathToken != null) {
            buf.append("@{");
            int start = buf.length();
            installPathToken.toStringBuffer(buf);
            if (installPathToken instanceof TextToken) {
                Replace.replace(buf, "}", "}}", start, buf.length());
            }
            buf.append("}");
        }
    }

    private static void register(HashMap map, Class cls) {
        Field f = FieldUtil.findField(cls, "TOKEN_NAME");
        f.setAccessible(true);
        String tokenName = (String)FieldUtil.getStatic(f);
        Constructor c = ConstructorUtil.findConstructor(cls, NestedConfigTemplate.class, Reader.class);
        if (c == null) {
            throw new IllegalArgumentException("not a token class");
        }
        c.setAccessible(true);
        map.put(tokenName, c);
    }

    public static InstalledComponentToken readPrimary(String name, NestedConfigTemplate template, Reader input) throws ConfigGenException, IOException {
        return InstalledComponentToken.read(PRIMARY_TOKENS, name, template, input);
    }

    public static InstalledComponentToken readSecondary(String name, NestedConfigTemplate template, Reader input) throws ConfigGenException, IOException {
        return InstalledComponentToken.read(SECONDARY_TOKENS, name, template, input);
    }

    private static InstalledComponentToken read(HashMap map, String name, NestedConfigTemplate template, Reader input) throws ConfigGenException, IOException {
        Constructor c = (Constructor)map.get(name);
        if (c == null) {
            return null;
        }
        try {
            return (InstalledComponentToken)ConstructorUtil.createObject(c, template, input);
        }
        catch (ConfigGenException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigGenException(e);
        }
    }

    protected Object clone() {
        try {
            return (InstalledComponentToken)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.toStringBuffer(result);
        return result.toString();
    }

    abstract void toStringBuffer(StringBuffer var1);

    void accept(TokenVisitor v) throws Exception {
    }

    InstalledComponentToken accept(TokenTransformer t) throws Exception {
        return t.clone(this);
    }

    InstalledComponentToken cloneForTransform() {
        return (InstalledComponentToken)this.clone();
    }

    InstalledComponentToken cloneForMapNames() {
        return this.cloneForTransform();
    }

    InstalledComponentToken mapNames(NameMapper mapper) {
        try {
            return this.accept(mapper);
        }
        catch (Exception e) {
            throw mapper.mapException(e);
        }
    }

    void validateNamespace(TokenPluginNSValidator v) throws Exception {
        this.accept(v);
    }

    static {
        InstalledComponentToken.register(PRIMARY_TOKENS, DefaultComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, SystemTypeComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, SystemServiceComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, NestedRefComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, TopLevelRefComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, DependeeComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, ContainerComponentToken.class);
        InstalledComponentToken.register(PRIMARY_TOKENS, TargetableComponentToken.class);
        SECONDARY_TOKENS = new HashMap();
        InstalledComponentToken.register(SECONDARY_TOKENS, NestedRefComponentToken.class);
        InstalledComponentToken.register(SECONDARY_TOKENS, TopLevelRefComponentToken.class);
        InstalledComponentToken.register(SECONDARY_TOKENS, DependeeComponentToken.class);
        InstalledComponentToken.register(SECONDARY_TOKENS, ContainerComponentToken.class);
    }
}

