/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.NameMapper;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import java.io.IOException;

class HostVarToken
extends Token {
    private String mVarName;
    private HostRedirectData mTargetRedirect;
    private boolean mIsSeparatorToken = false;

    public HostVarToken(String varName, HostRedirectData targetRedirect) {
        this.mVarName = varName;
        this.mTargetRedirect = targetRedirect;
    }

    public HostVarToken(char separatorChar) {
        this(String.valueOf(separatorChar), HostVarToken.getRootRedirect());
        this.mIsSeparatorToken = true;
    }

    private static HostRedirectData getRootRedirect() {
        HostRedirectData hostRedirect = new HostRedirectData(null);
        hostRedirect.setRootRedirect(true);
        return hostRedirect;
    }

    public String getVarName() {
        return this.mVarName;
    }

    public HostRedirectData getTargetRedirect() {
        return this.mTargetRedirect;
    }

    public void validate(VariableSettingsSource vars, ValidationContext ctx, Caller container) throws ConfigGenException {
        ctx.checkPermitted(this);
        if (this.getTargetRedirect() != null) {
            this.getTargetRedirect().validate(vars, ctx, container);
        }
    }

    String resolveLocal(ConfigGenerator generator, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        return generator.resolveLocal(this, callbackScope, caller);
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(":[");
        if (!this.mIsSeparatorToken) {
            buf.append("target");
            InstalledComponentToken.redirectToStrBuf(this.mTargetRedirect, buf);
            buf.append(":");
        }
        buf.append(this.getVarName());
        buf.append("]");
    }

    protected Token accept(TokenTransformer t) throws Exception {
        HostVarToken result = (HostVarToken)super.accept(t);
        result.mTargetRedirect = t.transform(result.getTargetRedirect());
        return result;
    }

    protected void accept(TokenVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargetRedirect());
    }

    Token cloneForTransform() {
        if (this.getTargetRedirect() == null) {
            return this;
        }
        return super.cloneForTransform();
    }

    public Token mapNames(NameMapper mapper) {
        HostVarToken result = (HostVarToken)super.mapNames(mapper);
        result.mVarName = mapper.getNameMap().mapHostVar(this.mVarName);
        return result;
    }

    Token cloneForMapNames() {
        return super.cloneForTransform();
    }
}

