/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;

class HostRedirectData
implements Cloneable {
    private Token mTargetName;
    private boolean mIsRootRedirect = false;
    private int mNumParentRedirects = 0;

    public HostRedirectData(Token targetName) {
        this.mTargetName = targetName;
    }

    public Token getTargetName() {
        return this.mTargetName;
    }

    public boolean isRootRedirect() {
        return this.mIsRootRedirect;
    }

    void setRootRedirect(boolean isRootRedirect) {
        this.mIsRootRedirect = isRootRedirect;
    }

    public int getNumParentRedirects() {
        return this.mNumParentRedirects;
    }

    void addParentRedirect() {
        ++this.mNumParentRedirects;
    }

    public void validate(VariableSettingsSource vars, ValidationContext ctx, Caller container) throws ConfigGenException {
        if (this.getTargetName() != null) {
            this.getTargetName().validate(vars, ctx, container);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.toStringBuffer(result);
        return result.toString();
    }

    public void toStringBuffer(StringBuffer buf) {
        buf.append("(");
        int preTgtLength = buf.length();
        if (this.mTargetName != null) {
            this.mTargetName.toStringBuffer(buf);
        }
        int targetLength = buf.length() - preTgtLength;
        if (this.isRootRedirect()) {
            buf.append(targetLength == 0 ? "/" : "//");
        } else {
            int numParents = this.getNumParentRedirects();
            if (numParents > 0) {
                buf.append(targetLength == 0 ? ".." : "/..");
            }
            while (numParents > 1) {
                buf.append("/..");
                --numParents;
            }
        }
        buf.append(")");
    }

    protected Object clone() {
        try {
            return (HostRedirectData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void accept(TokenVisitor v) throws Exception {
        v.visit(this.getTargetName());
    }

    HostRedirectData accept(TokenTransformer t) throws Exception {
        HostRedirectData result = t.clone(this);
        result.mTargetName = t.transform(result.getTargetName());
        return result;
    }

    HostRedirectData cloneForTransform() {
        if (this.getTargetName() == null) {
            return this;
        }
        return (HostRedirectData)this.clone();
    }
}

