/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.HostRedirectData;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.DefaultInstalledTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import java.io.IOException;
import java.io.Reader;

class DefaultComponentToken
extends InstalledComponentToken {
    private String mCompPath;
    private String mCompName;
    private String mVersion;
    private Token mInstallPath;
    private HostRedirectData mTargetRedirect;
    public static final String TOKEN_NAME = "component";

    DefaultComponentToken(NestedConfigTemplate template, Reader input) throws IOException, ConfigGenException {
        this.mTargetRedirect = template.readTargetRedirect(input);
        template.readColon(input);
        StringBuffer fullName = new StringBuffer();
        int nameStart = template.readFullName(input, fullName);
        this.mCompPath = fullName.substring(0, nameStart);
        this.mCompName = fullName.substring(nameStart);
        this.mVersion = template.readVersion(input);
        this.mInstallPath = template.readInstallPath(input);
    }

    public String getCompPath() {
        return this.mCompPath;
    }

    public String getCompName() {
        return this.mCompName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public Token getInstallPath() {
        return this.mInstallPath;
    }

    public HostRedirectData getTargetRedirect() {
        return this.mTargetRedirect;
    }

    public InstalledTarget getTarget(ConfigGenerator generator, TargetedConfigContext cfgCtx, Caller caller, InstallDBContext idbCtx) throws IOException, ConfigGenException, PersistenceManagerException, RPCException {
        String installPath = this.getInstallPath() == null ? null : this.getInstallPath().toString(generator);
        InstalledComponentRef compRef = new InstalledComponentRef(this.getCompPath(), this.getCompName(), this.getVersion(), null, false, installPath, false);
        DefaultInstalledTargeter targeter = new DefaultInstalledTargeter(compRef, null);
        cfgCtx = this.redirectCurrentHost(this.getTargetRedirect(), generator, cfgCtx);
        return targeter.getInstalledTarget(cfgCtx, caller, idbCtx);
    }

    public void validate(VariableSettingsSource vars, boolean isPrimary, ValidationContext ctx, Caller container) throws ConfigGenException {
        if (isPrimary) {
            ctx.checkPermitted(this);
        }
        if (this.getTargetRedirect() != null) {
            this.getTargetRedirect().validate(vars, ctx, container);
        }
        if (this.getInstallPath() != null) {
            this.getInstallPath().validate(vars, ctx, container);
        }
    }

    void toStringBuffer(StringBuffer buf) {
        buf.append(TOKEN_NAME);
        DefaultComponentToken.redirectToStrBuf(this.getTargetRedirect(), buf);
        buf.append(":");
        if (this.getCompPath() != null) {
            buf.append(this.getCompPath());
        }
        buf.append(this.getCompName());
        if (this.getVersion() != null) {
            buf.append("#");
            buf.append(this.getVersion());
        }
        DefaultComponentToken.installPathToStrBuf(this.getInstallPath(), buf);
    }

    protected InstalledComponentToken accept(TokenTransformer t) throws Exception {
        DefaultComponentToken result = (DefaultComponentToken)super.accept(t);
        ComponentRef cr = new ComponentRef(result.getCompPath(), result.getCompName(), result.getVersion());
        ComponentRef cr2 = t.transform(cr);
        result.mCompName = cr2.getComponentName();
        result.mCompPath = cr2.getPathString();
        if (result.getCompPath() != null && !result.getCompPath().endsWith("/")) {
            result.mCompPath = result.mCompPath + "/";
        }
        result.mTargetRedirect = t.transform(result.getTargetRedirect());
        result.mInstallPath = t.transform(result.getInstallPath());
        return result;
    }

    protected void accept(TokenVisitor v) throws Exception {
        super.accept(v);
        ComponentRef cr = new ComponentRef(this.getCompPath(), this.getCompName(), this.getVersion());
        v.visit(cr);
        v.visit(this.getTargetRedirect());
        v.visit(this.getInstallPath());
    }
}

