/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.ContainerComponentToken;
import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.InstalledComponentVarToken;
import com.raplix.rolloutexpress.config.NameMap;
import com.raplix.rolloutexpress.config.NameMapper;
import com.raplix.rolloutexpress.config.SimpleVarToken;
import com.raplix.rolloutexpress.config.TargetedConfigGenerator;
import com.raplix.rolloutexpress.config.TextToken;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.TokenTransformer;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.util.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public class ConfigTemplate
implements Cloneable {
    private Vector mTokens;
    static final String SYS_TAG = "sys";
    static final char PERIOD_TAG = '.';

    ConfigTemplate(Reader inputSource) throws ConfigGenException, IOException {
        this.mTokens = this.tokenize(new BufferedReader(inputSource));
    }

    Token getFirstToken() {
        return this.mTokens.size() > 0 ? (Token)this.mTokens.get(0) : null;
    }

    void validate(VariableSettingsSource vars, ValidationContext ctx, Caller container) throws ConfigGenException {
        Iterator tokens = this.mTokens.iterator();
        while (tokens.hasNext()) {
            Token t = (Token)tokens.next();
            t.validate(vars, ctx, container);
        }
    }

    private Vector tokenize(Reader input) throws ConfigGenException, IOException {
        int ch;
        Vector<Token> tokens = new Vector<Token>();
        StringBuffer buf = new StringBuffer();
        while ((ch = input.read()) != -1) {
            if (ch == 58) {
                input.mark(1);
                ch = input.read();
                if (ch == 91) {
                    input.mark(1);
                    ch = input.read();
                    if (ch == 91) {
                        buf.append(":[");
                        continue;
                    }
                    input.reset();
                    this.addBufferedText(buf, tokens);
                    tokens.add(this.readVar(input));
                    continue;
                }
                input.reset();
                buf.append(':');
                continue;
            }
            buf.append((char)ch);
        }
        this.addBufferedText(buf, tokens);
        return tokens;
    }

    private void addBufferedText(StringBuffer buf, Vector tokens) {
        if (buf.length() > 0) {
            tokens.add(new TextToken(buf.toString()));
            buf.setLength(0);
        }
    }

    Token readVar(Reader input) throws IOException, ConfigGenException {
        String varName = this.readIdentifier(input, true);
        Token result = this.getVarToken(varName, input);
        this.readChar(']', input);
        return result;
    }

    void readChar(char ch, Reader input) throws IOException, ConfigGenException {
        if (input.read() != ch) {
            throw ConfigGenException.invalidVarRef();
        }
    }

    Token getVarToken(String varName, Reader input) throws IOException, ConfigGenException {
        return new SimpleVarToken(varName);
    }

    String readIdentifier(Reader input) throws IOException, ConfigGenException {
        StringBuffer result = new StringBuffer();
        this.readIdentifier(input, "", result);
        return result.toString();
    }

    String readIdentifier(Reader input, boolean isComponentVar) throws IOException, ConfigGenException {
        StringBuffer result = new StringBuffer();
        this.readIdentifier(input, "", result);
        if (result.toString().equals(SYS_TAG) && this.peek(input) == 46) {
            result.append((char)input.read());
            this.readIdentifier(input, "", result);
            String predef = result.toString();
            if (isComponentVar ? !ComponentConfigManager.isPredefName(predef) : !TargetedConfigGenerator.isPredefName(predef)) {
                throw ConfigGenException.invalidPrefixError(predef);
            }
        }
        return result.toString();
    }

    boolean readIdentifier(Reader input, String extraChars, StringBuffer result) throws IOException, ConfigGenException {
        boolean isIdentifier = true;
        int ch = input.read();
        if (!this.isIdentifierStart(ch)) {
            throw ConfigGenException.invalidVarRef();
        }
        result.append((char)ch);
        while (true) {
            input.mark(1);
            ch = input.read();
            if (this.isIdentifierChar(ch)) {
                result.append((char)ch);
                continue;
            }
            if (extraChars.indexOf(ch) == -1) break;
            result.append((char)ch);
            isIdentifier = false;
        }
        input.reset();
        return isIdentifier;
    }

    boolean isIdentifierStart(int ch) {
        return ch == 95 || ch != -1 && Character.isLetter((char)ch);
    }

    boolean isIdentifierChar(int ch) {
        return this.isIdentifierStart(ch) || this.isDigitChar((char)ch);
    }

    boolean isDigitChar(int ch) {
        return ch != -1 && Character.isDigit((char)ch);
    }

    boolean isAsciiDigitChar(int ch) {
        return ch >= 48 && ch <= 57;
    }

    int peek(Reader input) throws IOException {
        input.mark(1);
        int ch = input.read();
        input.reset();
        return ch;
    }

    void generate(ConfigGenerator generator, Writer out) throws IOException, ConfigGenException {
        int size = this.mTokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = (Token)this.mTokens.elementAt(i);
            out.write(token.toString(generator));
        }
    }

    public HashSet getSimpleVarNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator tokens = this.mTokens.iterator();
        while (tokens.hasNext()) {
            Token t = (Token)tokens.next();
            if (!(t instanceof SimpleVarToken)) continue;
            result.add(((SimpleVarToken)t).getVarName());
        }
        return result;
    }

    public HashSet getPrimaryContainerVarNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator tokens = this.mTokens.iterator();
        while (tokens.hasNext()) {
            InstalledComponentVarToken icvt;
            Iterator compIter;
            InstalledComponentToken first;
            Token t = (Token)tokens.next();
            if (!(t instanceof InstalledComponentVarToken) || !((first = (InstalledComponentToken)(compIter = (icvt = (InstalledComponentVarToken)t).getInstalledComponentTokenList()).next()) instanceof ContainerComponentToken) || compIter.hasNext()) continue;
            result.add(icvt.getVarName());
        }
        return result;
    }

    protected Object clone() {
        try {
            return (ConfigTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.mTokens.iterator();
        while (iter.hasNext()) {
            Token t = (Token)iter.next();
            t.toStringBuffer(sb);
        }
        return sb.toString();
    }

    public ConfigTemplate mapNames(NameMap map) {
        NameMapper mapper = new NameMapper(map);
        try {
            return mapper.transform(this);
        }
        catch (Exception e) {
            throw mapper.mapException(e);
        }
    }

    public static String mapNames(NameMap map, String var) {
        NameMapper mapper = new NameMapper(map);
        try {
            return ConfigTemplate.transform(mapper, var);
        }
        catch (Exception e) {
            throw mapper.mapException(e);
        }
    }

    static String transform(TokenTransformer t, String var) throws Exception {
        if (var == null) {
            return null;
        }
        ConfigTemplate ct = ConfigTemplate.parse(var, t.reportErrors());
        if (ct == null) {
            return var;
        }
        return t.transform(ct).toString();
    }

    static void visit(TokenVisitor t, String var) throws Exception {
        if (var == null) {
            return;
        }
        ConfigTemplate ct = ConfigTemplate.parse(var, t.reportErrors());
        if (ct != null) {
            t.visit(ct);
        }
    }

    private static ConfigTemplate parse(String var, boolean reportErrors) throws ConfigGenException {
        ConfigParser cp = ConfigParser.VALIDATION_PARSER;
        try {
            return cp.createNestedTemplate(var);
        }
        catch (ConfigGenException e) {
            if (reportErrors) {
                throw e;
            }
            if (Logger.isWarnEnabled(cp)) {
                Logger.warn(e.getMessage(), cp);
            }
            return null;
        }
    }

    void accept(TokenVisitor t) throws Exception {
        if (t.reportErrors()) {
            TokenCallContext tcc = t.getTokenCallContext();
            this.validate(tcc.getVariableSettingsSource(), tcc.getValidationContext(), tcc.getCaller());
        }
        Iterator iter = this.mTokens.iterator();
        while (iter.hasNext()) {
            Token tok = (Token)iter.next();
            t.visit(tok);
        }
    }

    ConfigTemplate accept(TokenTransformer t) throws Exception {
        if (t.reportErrors()) {
            TokenCallContext tcc = t.getTokenCallContext();
            this.validate(tcc.getVariableSettingsSource(), tcc.getValidationContext(), tcc.getCaller());
        }
        ConfigTemplate result = t.clone(this);
        result.mTokens = new Vector();
        Iterator iter = this.mTokens.iterator();
        while (iter.hasNext()) {
            Token tok = (Token)iter.next();
            result.mTokens.add(t.transform(tok));
        }
        return result;
    }

    ConfigTemplate cloneForTransform() {
        return (ConfigTemplate)this.clone();
    }
}

