/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.NestedConfigTemplate;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class ConfigParser {
    static final ConfigParser VALIDATION_PARSER = new ConfigParser();

    public ConfigTemplate createTemplate(String source) throws ConfigGenException {
        return this.createTemplate(this.toReader(source));
    }

    public ConfigTemplate createTemplate(Reader source) throws ConfigGenException {
        try {
            if (source == null) {
                return null;
            }
            return new ConfigTemplate(source);
        }
        catch (IOException e) {
            throw ConfigGenException.ioError(e);
        }
    }

    public ConfigTemplate createNestedTemplate(String source) throws ConfigGenException {
        try {
            if (source == null) {
                return null;
            }
            return new NestedConfigTemplate(this.toReader(source));
        }
        catch (IOException e) {
            throw ConfigGenException.ioError(e);
        }
    }

    private Reader toReader(String source) {
        if (source == null) {
            return null;
        }
        return new StringReader(source);
    }
}

