/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.CallerConfigGenerator;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenContext;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.HostVarToken;
import com.raplix.rolloutexpress.config.InstalledComponentVarToken;
import com.raplix.rolloutexpress.config.LocalConfigGenerator;
import com.raplix.rolloutexpress.config.SessionConfigGenerator;
import com.raplix.rolloutexpress.config.SessionVarToken;
import com.raplix.rolloutexpress.config.SimpleVarToken;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.TargetedConfigGenerator;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class ConfigGenerator {
    static final ConfigGenerator NO_OP_GENERATOR = new ConfigGenerator((ConfigGenContext)null);
    private ConfigGenContext mContext;
    private ConfigGenerator mParentScope;
    private static final String DEFAULT_COMP_SAVE_NAME = "default";
    private static final String COMPREF_COMP_SAVE_NAME = "compRef";

    ConfigGenerator(ConfigGenContext context) {
        this(context, null);
    }

    ConfigGenerator(ConfigGenerator parentScope) {
        this(parentScope.getContext(), parentScope);
    }

    private ConfigGenerator(ConfigGenContext context, ConfigGenerator parentScope) {
        this.mContext = context;
        this.mParentScope = parentScope;
    }

    public ConfigParser getConfigParser() {
        return this.getContext().getConfigParser();
    }

    ConfigGenerator getParentScope() {
        return this.mParentScope;
    }

    ConfigGenContext getContext() {
        return this.mContext;
    }

    public String generate(ConfigTemplate template) throws ConfigGenException {
        if (template == null) {
            return null;
        }
        StringWriter out = new StringWriter();
        this.generate(template, (Writer)out);
        out.flush();
        return out.toString();
    }

    public void generate(ConfigTemplate template, Writer writer) throws ConfigGenException {
        try {
            if (template == null) {
                return;
            }
            template.generate(this, writer);
        }
        catch (IOException e) {
            throw ConfigGenException.ioError(e);
        }
    }

    public String generate(String template) throws ConfigGenException {
        return this.generate(this.getConfigParser().createTemplate(template));
    }

    public void generate(Reader template, Writer writer) throws ConfigGenException {
        this.generate(this.getConfigParser().createTemplate(template), writer);
    }

    public static String escapeVarRefs(String str) {
        String varStartStr = ":[";
        int len = str.length();
        int varStartNdx = str.indexOf(varStartStr);
        if (varStartNdx == -1) {
            return str;
        }
        StringBuffer result = new StringBuffer(len + 5);
        int start = 0;
        while (varStartNdx != -1) {
            result.append(str.substring(start, varStartNdx + 2));
            result.append('[');
            start = varStartNdx + 2;
            varStartNdx = str.indexOf(varStartStr, start);
        }
        if (start < len) {
            result.append(str.substring(start));
        }
        return result.toString();
    }

    public ComponentConfigManager newComponentManager(GeneratedVariableSettingsID varsID) throws ConfigGenException, RPCException {
        return new ComponentConfigManager(this, this.getGenVars(varsID));
    }

    public ConfigGenerator newUnresVarScope(VariableSettingsSource vars) throws ConfigGenException {
        return new LocalConfigGenerator(this, vars, true);
    }

    public ConfigGenerator newCallScope(VariableSettingsSource formals, VariableSettingsSource actuals) throws ConfigGenException {
        VariableSettingsHolder vars = new VariableSettingsHolder();
        String[] names = formals.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            String val = actuals.getVarValue(names[i]);
            if (val == null) {
                val = formals.getVarValue(names[i]);
                if (val == null) {
                    throw ConfigGenException.missingParamValue(names[i]);
                }
                val = this.generateNested(val);
            }
            vars.setVarValue(names[i], val);
        }
        return new LocalConfigGenerator(this, vars, false);
    }

    public ConfigGenerator newCallerScope(Caller caller) {
        return new CallerConfigGenerator(this, caller);
    }

    public ComponentConfigManager newComponentManager(Component comp, ComponentVariableSettings overrides) throws ConfigGenException, RPCException {
        String name;
        VariableSettingsSource vars;
        if (overrides == null) {
            vars = null;
            name = DEFAULT_COMP_SAVE_NAME;
        } else {
            vars = overrides.getOverrideVariableSettingsSource();
            name = overrides.getName();
        }
        return new ComponentConfigManager(this, comp, vars, false, name, null, null);
    }

    public ComponentConfigManager newComponentManager(Component comp, GeneratedVariableSettingsID overrides) throws ConfigGenException, RPCException {
        String name;
        GeneratedVariableSettings genVars;
        if (overrides == null) {
            genVars = null;
            name = DEFAULT_COMP_SAVE_NAME;
        } else {
            genVars = this.getGenVars(overrides);
            name = genVars.getName();
        }
        return new ComponentConfigManager(this, comp, genVars, false, name, null, null);
    }

    public ComponentConfigManager newComponentRefManager(Component comp, VariableSettingsSource overrides, InstalledComponentID containerID, String containerRefName) throws ConfigGenException, RPCException {
        String name = COMPREF_COMP_SAVE_NAME;
        return new ComponentConfigManager(this, comp, overrides, true, name, containerID, containerRefName);
    }

    public ConfigGenerator newTargetScope(TargetedConfigContext ctx, InstallDBContext installDBContext) {
        return new TargetedConfigGenerator(this, ctx, installDBContext);
    }

    public ConfigGenerator newSessionScope(SessionManager sessionManager, boolean inHideSecureValues) throws ConfigGenException {
        return new SessionConfigGenerator(this, sessionManager, inHideSecureValues);
    }

    public void setVarValue(String inName, String inValue) throws ConfigGenException, IOException {
        this.resolve(new SimpleVarToken(inName), this, null);
        if (this.getParentScope() == null) {
            throw ConfigGenException.variableAssignationNotAllowed(inName);
        }
        this.getParentScope().setVarValue(inName, inValue);
    }

    GeneratedVariableSettings getGenVars(GeneratedVariableSettingsID id) throws ConfigGenException, RPCException {
        return this.getContext().getVarManager().getVariableSettings(id);
    }

    String resolve(Token token, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        String result = token.resolveLocal(this, callbackScope, caller);
        if (result == null) {
            if (this.getParentScope() != null) {
                result = this.getParentScope().resolve(token, callbackScope, caller);
            } else {
                throw ConfigGenException.undefinedVar(token.toString());
            }
        }
        return result;
    }

    String resolveLocal(SimpleVarToken token, ConfigGenerator callbackScope, Caller caller) throws ConfigGenException, IOException {
        return null;
    }

    String resolveLocal(HostVarToken token, ConfigGenerator callbackGenerator, Caller caller) throws ConfigGenException, IOException {
        return null;
    }

    String resolveLocal(InstalledComponentVarToken token, ConfigGenerator callbackGenerator, Caller caller) throws ConfigGenException, IOException {
        return null;
    }

    String resolveLocal(SessionVarToken token, ConfigGenerator callbackGenerator, Caller caller) throws ConfigGenException, IOException {
        return null;
    }

    static String toStr(String s) {
        return s == null ? "" : s;
    }

    MachineInfo getMachineInfo(String varName) throws ConfigGenException {
        if (this.getParentScope() != null) {
            return this.getParentScope().getMachineInfo(varName);
        }
        throw ConfigGenException.noMachineInfoOnHostError("unknown", varName);
    }

    String generateNested(String value) throws ConfigGenException {
        return this.generate(this.getConfigParser().createNestedTemplate(value));
    }

    public String toString() {
        return this.getClass() + ":" + this.mParentScope;
    }

    public static void validatePlanParams(ExecutionPlan plan) throws ConfigGenException {
        ConfigGenerator.validate(plan.getParams(), null, false, ValidationContext.PLAN_PARAM_CTX, plan.toCaller(), "config.locator.planParam");
    }

    public static void validatePlanLocalVars(Caller plan, ExecutionPlanData planData, VariableSettingsSource predefs) throws ConfigGenException {
        ValidationContext ctx = planData.isSimplePlan() ? ValidationContext.SIMPLE_PLAN_VAR_CTX : ValidationContext.COMPOSITE_PLAN_VAR_CTX;
        ConfigGenerator.validate(planData.getLocalVars(), predefs, true, ctx, plan, "config.locator.planVar");
    }

    private static void validate(VariableSettingsSource current, VariableSettingsSource predefs, boolean canUsePriorVar, ValidationContext ctx, Caller container, String locatorCode) throws ConfigGenException {
        int i;
        VariableSettingsHolder vars = new VariableSettingsHolder();
        if (predefs != null) {
            String[] predefNames = predefs.getVarNames();
            for (i = 0; i < predefNames.length; ++i) {
                String val = predefs.getVarValue(predefNames[i]);
                if (val == null) continue;
                vars.setVarValue(predefNames[i], val);
            }
        }
        String[] names = current.getVarNames();
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            if (current.containsVarValue(name)) {
                String val = current.getVarValue(name);
                try {
                    ConfigParser.VALIDATION_PARSER.createNestedTemplate(val).validate(vars, ctx, container);
                }
                catch (ConfigGenException e) {
                    throw ConfigGenException.invalidVarValue(name, locatorCode, e);
                }
            }
            if (!canUsePriorVar) continue;
            vars.setVarValue(name, "found");
        }
    }
}

