/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenManager;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.Messages;
import com.raplix.rolloutexpress.config.PersistentVariableSettings;
import com.raplix.rolloutexpress.config.RemoteConfigGenManager;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import java.util.HashSet;

public class ConfigGenSubsystem
extends Subsystem
implements VariableSettingsManager,
ConfigGenManager,
Messages {
    private ConfigGenManager mConfigGenMgr;
    public static final String CONFIG_VARNAME_ALLOW_SESSIONID_HOSTS = "config.allowSessionIDOnHosts";
    private static final String DEFAULT_CONFIG_ALLOW_SESSIONID_HOSTS = "";
    private static final String DOC_CONFIG_ALLOW_SESSIONID_HOSTS = ROXMessageManager.messageAsString("config.DOC_CONFIG_ALLOW_SESSIONID_HOSTS");
    private static DefaultConfiguration[] sDefaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration("config.allowSessionIDOnHosts", "", DOC_CONFIG_ALLOW_SESSIONID_HOSTS)};
    private HashSet mAllowSessionIDOnHosts = new HashSet();
    private static ConfigGenSubsystem sInstance;

    public ConfigGenSubsystem(Application app) throws ConfigurationException {
        super(app);
        this.mConfigGenMgr = new RemoteConfigGenManager(this);
        sInstance = this;
        this.initAllowSessionIDOnHosts();
    }

    public void registerRPCInterfaces(RPCManager rpc) throws RPCException {
        rpc.registerService(VariableSettingsManager.class, this);
    }

    private ConfigGenSubsystem() {
    }

    public String getSubsystemName() {
        return ROXMessageManager.messageAsString("config.SUBSYSTEM_NAME");
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        return sDefaultConfiguration;
    }

    public GeneratedVariableSettings getVariableSettings(GeneratedVariableSettingsID id) throws ConfigGenException {
        PersistentVariableSettings pvs = new PersistentVariableSettings(id);
        return new GeneratedVariableSettings(pvs);
    }

    public GeneratedVariableSettingsID generateVariableSettings(ComponentVariableSettings compVars) throws RPCException, ConfigGenException {
        VariableSettingsSource overrides = compVars.getOverrideVariableSettingsSource();
        return this.save(compVars.getName(), overrides);
    }

    public GeneratedVariableSettingsID saveVariableSettings(String name, VariableSettingsHolder vars) throws ConfigGenException {
        return this.save(name, vars);
    }

    private GeneratedVariableSettingsID save(String name, VariableSettingsSource vars) throws ConfigGenException {
        try {
            PersistentVariableSettings pvs = new PersistentVariableSettings(name, vars);
            pvs.save();
            return (GeneratedVariableSettingsID)pvs.getObjectID();
        }
        catch (PersistenceManagerException e) {
            throw ConfigGenException.saveError(e);
        }
    }

    public void updateInstalledCompVars(String typeName) throws ConfigGenException, PersistenceManagerException {
        MultiInstalledComponentQuery micq = MultiInstalledComponentQuery.byType(typeName);
        try {
            InstalledComponentBean[] icb = micq.select();
            for (int i = 0; i < icb.length; ++i) {
                ComponentConfigManager ccm = new ComponentConfigManager(icb[i], this.getConfigGenerator());
                this.updateVariableSettings(icb[i].getGeneratedVariableSettings(), ccm.getGeneratedVariables());
            }
        }
        catch (RPCException rpce) {
            throw new ConfigGenException(rpce);
        }
    }

    private void updateVariableSettings(GeneratedVariableSettings vars, VariableSettingsSource values) throws PersistenceManagerException {
        PersistentVariableSettings pvs = vars.getData();
        pvs.updateVariables(values);
        pvs.save();
    }

    public ConfigGenerator getConfigGenerator() {
        return this.mConfigGenMgr.getConfigGenerator();
    }

    public ConfigParser getConfigParser() {
        return this.mConfigGenMgr.getConfigParser();
    }

    public boolean allowSessionIDOnHost(String hostName) {
        return this.mAllowSessionIDOnHosts.contains(hostName);
    }

    private void initAllowSessionIDOnHosts() throws ConfigurationException {
        String allowOnHosts = this.getConfigurationAsString(CONFIG_VARNAME_ALLOW_SESSIONID_HOSTS);
        if (allowOnHosts.length() == 0) {
            return;
        }
        String[] hostNames = allowOnHosts.split(",");
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                Host.validateName(hostNames[i]);
            }
            catch (HostDBException e) {
                ROXMessage msg = new ROXMessage("config.INVALID_SESSIONID_HOSTNAME", hostNames[i]);
                throw new ConfigurationException(msg, (Throwable)e);
            }
            this.mAllowSessionIDOnHosts.add(hostNames[i]);
        }
    }

    static ConfigGenSubsystem getInstance() {
        return sInstance;
    }
}

