/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.config.InstalledComponentToken;
import com.raplix.rolloutexpress.config.Messages;
import com.raplix.rolloutexpress.config.Token;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.util.message.MessageManager;
import java.io.IOException;

public class ConfigGenException
extends CommandException
implements Messages {
    protected ConfigGenException() {
    }

    public ConfigGenException(ROXMessage msg, Throwable t) {
        super(msg, t);
    }

    ConfigGenException(ROXMessage msg, Throwable t, int wrappingMode) {
        super(msg, t, wrappingMode);
    }

    public ConfigGenException(ROXMessage msg) {
        super(msg);
    }

    public ConfigGenException(Throwable t) {
        super(t);
    }

    public static ConfigGenException retrieveError(Throwable t) {
        return ConfigGenException.newSystemError("config.RETR_ERR", t);
    }

    public static ConfigGenException saveError(Throwable t) {
        return ConfigGenException.newSystemError("config.SAVE_ERR", t);
    }

    public static ConfigGenException noSuchObjectError(Throwable t) {
        return ConfigGenException.newSystemError("config.NO_SUCH_OBJ_ERR", t);
    }

    public static ConfigGenException noSuchObjectError(Token token, Exception nested) {
        return ConfigGenException.newSystemError("config.NO_SUCH_OBJ_INSTALLED_ERR", token.toString(), nested);
    }

    public static ConfigGenException undefinedVar(String varName) {
        return ConfigGenException.newValidationError("config.UNDEF_VAR_ERR", varName);
    }

    public static ConfigGenException invalidVarRef() {
        return ConfigGenException.newValidationError("config.BAD_VAR_REF_ERR");
    }

    public static ConfigGenException invalidNestedVarRef() {
        return ConfigGenException.newValidationError("config.BAD_NESTED_VAR_REF_ERR");
    }

    public static ConfigGenException noAccessToComp(InstalledComponentToken compRefToken) {
        return ConfigGenException.newSystemError("config.NO_COMP_ACCESS", compRefToken.toString());
    }

    public static ConfigGenException unknownCompVar(Token compRefToken) {
        return ConfigGenException.newSystemError("config.UNKNOWN_COMP_VAR", compRefToken.toString());
    }

    public static ConfigGenException missingParamValue(String paramName) {
        return ConfigGenException.newValidationError("config.MISSING_PARAM", paramName);
    }

    public static ConfigGenException ioError(IOException e) {
        return ConfigGenException.newSystemError("config.IO_ERR", e);
    }

    public static ConfigGenException noRAOnHostError(Host host, String varName) {
        return ConfigGenException.newSystemError("config.NO_RA_ERR", host.getName(), varName);
    }

    public static ConfigGenException noMachineInfoOnHostError(String hostName, String varName) {
        return ConfigGenException.newSystemError("config.NO_MACHINE_INFO_ERR", hostName, varName);
    }

    public static ConfigGenException invalidHostRef(String hostRef, Exception nested) {
        return ConfigGenException.newSystemError("config.INVALID_HOST_REF", hostRef, nested);
    }

    public static ConfigGenException invalidCompGenVarSet() {
        return ConfigGenException.newSystemError("config.INVALID_COMP_GEN_VAR_SET");
    }

    public static ConfigGenException noCallerScope() {
        return ConfigGenException.newSystemError("config.NO_CALLER_CG");
    }

    public static ConfigGenException noComponentInCallerScope() {
        return ConfigGenException.newSystemError("config.NO_COMP_CALLER_CG");
    }

    public static ConfigGenException unrelatedComponentInCallerScope() {
        return ConfigGenException.newSystemError("config.UNRELATED_COMP_CALLER_CG");
    }

    public static ConfigGenException nonComponentCaller(InstalledComponentToken token) {
        return ConfigGenException.newSystemError("config.NON_COMP_CALLER", token.toString());
    }

    public static ConfigGenException notPermitted(Token token) {
        return ConfigGenException.newValidationError("config.VAR_REF_NOT_PERMITTED", token.toString());
    }

    public static ConfigGenException notPermitted(InstalledComponentToken token) {
        return ConfigGenException.newValidationError("config.COMP_REF_NOT_PERMITTED", token.toString());
    }

    public static ConfigGenException invalidVarValue(String varName, String locator, Exception detail) {
        String location = MessageManager.messageAsString(locator);
        String[] args = new String[]{location, varName};
        return ConfigGenException.newValidationError("config.INVALID_VAR_VALUE", args, detail);
    }

    public static ConfigGenException reservedVarNameError(String name) {
        return ConfigGenException.newValidationError("config.RES_VARNAME_ERR", name);
    }

    public static ConfigGenException invalidPrefixError(String name) {
        return ConfigGenException.newValidationError("config.INVALID_PREFIX_ERR", name);
    }

    static ConfigGenException mutableVarOutOfScope(String name) {
        return ConfigGenException.newValidationError("config.MUTABLE_VAR_OUT_OF_SCOPE", name);
    }

    static ConfigGenException noHostForSessionID() {
        return ConfigGenException.newSystemError("config.NO_HOST_FOR_SESSION_ID");
    }

    static ConfigGenException noMSForSessionID() {
        return ConfigGenException.newSystemError("config.NO_MS_FOR_SESSION_ID");
    }

    static ConfigGenException noSessionID() {
        return ConfigGenException.newSystemError("config.NO_SESSION_ID");
    }

    static ConfigGenException variableAssignationNotAllowed(String name) {
        return ConfigGenException.newSystemError("config.VARIABLE_ASSIGNATION_NOT_ALLOWED", name);
    }

    static ConfigGenException sessionIDNotAllowedOnHost(String hostName) {
        return ConfigGenException.newValidationError("config.SESSIONID_NOT_ALLOWED_ON_HOST", hostName);
    }

    public static ConfigGenException invalidPredefSessionVar(String name) {
        return ConfigGenException.newValidationError("config.INVALID_PREDEF_SESSION_VAR", name);
    }

    private static ConfigGenException newSystemError(String code, Throwable t) {
        return new ConfigGenException(new ROXMessage(code), t);
    }

    private static ConfigGenException newSystemError(String code, String arg) {
        return new ConfigGenException(new ROXMessage(code, new String[]{arg}));
    }

    private static ConfigGenException newSystemError(String code, String arg, Throwable t) {
        return new ConfigGenException(new ROXMessage(code, new String[]{arg}), t, 0);
    }

    private static ConfigGenException newSystemError(String code, String arg1, String arg2) {
        return new ConfigGenException(new ROXMessage(code, new String[]{arg1, arg2}));
    }

    private static ConfigGenException newSystemError(String code) {
        return new ConfigGenException(new ROXMessage(code));
    }

    private static ConfigGenException newValidationError(String code, String arg) {
        return ConfigGenException.newValidationError(code, new String[]{arg});
    }

    private static ConfigGenException newValidationError(String code) {
        return ConfigGenException.newValidationError(code, new String[0]);
    }

    private static ConfigGenException newValidationError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new ConfigGenException(msg);
    }

    private static ConfigGenException newValidationError(String code, String[] args, Exception detail) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new ConfigGenException(msg, (Throwable)detail);
    }
}

