/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.config;

import com.raplix.rolloutexpress.command.exceptions.PathDoesNotExistException;
import com.raplix.rolloutexpress.config.ConfigGenContext;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.LocalConfigGenerator;
import com.raplix.rolloutexpress.config.ValidationContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ComponentConfigManager {
    private static final String ROOT_TYPE_NAME = "$root$";
    private static final char KEY_SEP = ':';
    private static final String PREDEF_NAME = "sys.name";
    private static final String PREDEF_VERSION = "sys.version";
    private static final String PREDEF_DESCRIPTION = "sys.description";
    private static final String PREDEF_LABEL = "sys.label";
    private static final String PREDEF_SOFTWARE_VENDOR = "sys.softwareVendor";
    private static final String PREDEF_AUTHOR = "sys.author";
    private static final String PREDEF_PATH = "sys.path";
    public static final String PREDEF_RSRC_INSTALL_PATH = "sys.rsrcInstallPath";
    public static final String PREDEF_TARGET_REF_NAME = "sys.targetRefName";
    static final String[] SYSTEM_COMP_VARS = new String[]{"sys.name", "sys.version", "sys.description", "sys.label", "sys.softwareVendor", "sys.author", "sys.path"};
    private Hashtable mCompVarMap = new Hashtable();
    private ConfigGenerator mParentScope;
    private GeneratedVariableSettingsID mSaveID;
    private String mSaveName;

    ComponentConfigManager(ConfigGenerator parentScope, GeneratedVariableSettings savedVars) throws ConfigGenException {
        this.setParentScope(parentScope);
        this.setSaveID(savedVars.getID());
        String[] varNames = savedVars.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            int sepNdx = varNames[i].indexOf(58);
            if (sepNdx == -1) {
                throw ConfigGenException.invalidCompGenVarSet();
            }
            String compKey = varNames[i].substring(0, sepNdx);
            String varName = varNames[i].substring(sepNdx + 1);
            VariableSettingsHolder compVars = (VariableSettingsHolder)this.mCompVarMap.get(compKey);
            if (compVars == null) {
                compVars = new VariableSettingsHolder();
                this.mCompVarMap.put(compKey, compVars);
            }
            compVars.setVarValue(varName, savedVars.getVarValue(varNames[i]));
        }
    }

    ComponentConfigManager(ConfigGenerator parentScope, Component comp, VariableSettingsSource overrides, boolean overridesResolved, String saveName, InstalledComponentID containerID, String containerRefName) throws ConfigGenException {
        this.setParentScope(parentScope);
        this.setSaveName(saveName);
        if (overrides == null) {
            overrides = new VariableSettingsHolder();
        }
        this.initDefaultCompVars(comp, comp);
        InstalledComponent tmpInstComp = this.createTempInstComp(comp, containerID, containerRefName);
        this.resolveCompVars(comp, comp, overrides, overridesResolved, tmpInstComp);
        this.initTargetRefName(comp);
        this.initRsrcInstallPath(comp);
    }

    ComponentConfigManager(InstalledComponentBean instComp, ConfigGenerator configGen) throws ConfigGenException, PersistenceManagerException, RPCException {
        this(configGen, instComp.getGeneratedVariableSettings());
        Component comp = instComp.getComponentID().getByIDQuery().select();
        this.resolveCompVars(comp, comp, new VariableSettingsHolder(), true, instComp.getInstalledComponent());
    }

    private InstalledComponent createTempInstComp(Component comp, InstalledComponentID containerID, String containerRefName) {
        PersistentInstalledComponent pic = new PersistentInstalledComponent();
        pic.setComponentID(comp.getID());
        pic.setObjectID(InstalledComponentID.generateInstalledComponentID());
        pic.setParentContainerID(containerID);
        pic.setParentContainerRefName(containerRefName);
        return new InstalledComponent(pic);
    }

    public static void validate(VariableSettingsSource source, Caller container) throws ConfigGenException {
        ComponentConfigManager.validate(source, source, container);
    }

    public static void validate(VariableSettingsSource current, VariableSettingsSource predefs, Caller container) throws ConfigGenException {
        ValidationContext ctx = ValidationContext.COMP_VAR_CTX;
        VariableSettingsHolder vars = new VariableSettingsHolder();
        for (int i = 0; i < SYSTEM_COMP_VARS.length; ++i) {
            vars.setVarValue(SYSTEM_COMP_VARS[i], "");
        }
        String[] names = predefs.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (current.containsVarValue(name)) {
                if (ComponentConfigManager.isPredefName(name)) {
                    throw ConfigGenException.reservedVarNameError(name);
                }
                String val = current.getVarValue(name);
                ConfigParser.VALIDATION_PARSER.createNestedTemplate(val).validate(vars, ctx, container);
            }
            vars.setVarValue(name, "found");
        }
    }

    public static boolean isPredefName(String name) {
        return ComponentConfigManager.containsName(SYSTEM_COMP_VARS, name) || PREDEF_RSRC_INSTALL_PATH.equals(name) || PREDEF_TARGET_REF_NAME.equals(name);
    }

    private static boolean containsName(String[] names, String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private void initDefaultCompVars(Component current, Component actual) {
        if (current.isDerivedComponent()) {
            this.initDefaultCompVars(current.getExtendsType().getComponent(), actual);
        }
        VariableSettingsHolder compVars = new VariableSettingsHolder();
        this.add(compVars, PREDEF_PATH, actual.getPath().getFullPathString());
        this.add(compVars, PREDEF_NAME, actual.getName());
        this.add(compVars, PREDEF_VERSION, actual.getVersionNumber().getAsString());
        this.add(compVars, PREDEF_DESCRIPTION, actual.getDescription());
        this.add(compVars, PREDEF_LABEL, actual.getLabel());
        this.add(compVars, PREDEF_SOFTWARE_VENDOR, actual.getSoftwareVendor());
        this.add(compVars, PREDEF_AUTHOR, actual.getAuthor());
        this.mCompVarMap.put(this.getKey(current), compVars);
    }

    private void add(VariableSettingsHolder vars, String varName, String varValue) {
        vars.setVarValue(varName, ConfigGenerator.toStr(varValue));
    }

    private Object getKey(SummaryComponent comp) {
        String typeName = comp.getExtendsTypeName();
        if (typeName == null) {
            typeName = ROOT_TYPE_NAME;
        }
        return typeName;
    }

    private VariableSettingsHolder getCompVarHolder(SummaryComponent comp) {
        return (VariableSettingsHolder)this.mCompVarMap.get(this.getKey(comp));
    }

    private ConfigGenerator newScope(Component comp, InstalledComponent instComp) throws ConfigGenException {
        return this.newCallerScope(new Caller(instComp, comp));
    }

    private void resolveCompVars(Component current, Component initial, VariableSettingsSource overrides, boolean overridesResolved, InstalledComponent instComp) throws ConfigGenException {
        if (current.isDerivedComponent()) {
            this.resolveCompVars(current.getExtendsType().getComponent(), initial, overrides, overridesResolved, instComp);
        }
        CallSpec callSpec = current.getThisCallSpec();
        VarDecl[] compVars = initial.getVarList(callSpec);
        VariableSettingsHolder localVars = this.getCompVarHolder(current);
        for (int i = 0; i < compVars.length; ++i) {
            String varName = compVars[i].getName();
            if (localVars.containsVarValue(varName)) continue;
            boolean isResolved = overridesResolved;
            String val = null;
            Component declaringComp = null;
            if (!Modifier.FINAL.equals(compVars[i].getModifier()) && this.isSame(initial.resolveVar(varName, null), compVars[i])) {
                val = overrides.getVarValue(varName);
                declaringComp = initial;
            }
            if (val == null) {
                isResolved = false;
                val = compVars[i].getDefaultValue();
                declaringComp = compVars[i].getDeclaringComponent();
            }
            if (!isResolved) {
                val = this.newScope(declaringComp, instComp).generateNested(val);
            }
            this.add(initial, compVars[i], val);
        }
    }

    private boolean isSame(Component c1, Component c2) {
        return c1 == c2 || c1.getID().equals(c2.getID());
    }

    private boolean isSame(VarDecl v1, VarDecl v2) {
        return v1 != null && v1.getName().equals(v2.getName()) && this.isSame(v1.getDeclaringComponent(), v2.getDeclaringComponent());
    }

    private void add(Component initial, VarDecl decl, String value) {
        String varName = decl.getName();
        while (!this.isSame(initial.resolveVar(varName, null), decl)) {
            initial = initial.getExtendsType().getComponent();
        }
        this.getCompVarHolder(initial).setVarValue(varName, value);
        while (decl != null) {
            Component declarer = decl.getDeclaringComponent();
            while (!this.isSame(initial, declarer)) {
                initial = initial.getExtendsType().getComponent();
                this.getCompVarHolder(initial).setVarValue(varName, value);
            }
            decl = decl.getOverriddenVarDecl();
        }
    }

    private void initRsrcInstallPath(Component comp) throws ConfigGenException {
        try {
            if (!comp.isSimpleComponent()) {
                return;
            }
            ResourceDefinition rsrcDef = comp.getResourceInstallSpec();
            rsrcDef = rsrcDef.generate(this, comp, this.getMachineInfo());
            String rsrcInstallPath = rsrcDef.getRAFullTargetPath();
            Iterator allCompVars = this.mCompVarMap.values().iterator();
            while (allCompVars.hasNext()) {
                VariableSettingsHolder compVars = (VariableSettingsHolder)allCompVars.next();
                compVars.setVarValue(PREDEF_RSRC_INSTALL_PATH, rsrcInstallPath);
            }
        }
        catch (ComponentDBException e) {
            throw new ConfigGenException(e);
        }
        catch (PathDoesNotExistException e) {
            throw new ConfigGenException(e);
        }
    }

    private void initTargetRefName(Component comp) throws ConfigGenException {
        if (comp == null || comp.getTargetRef() == null) {
            return;
        }
        this.cascadeTargetRefName(comp);
    }

    /*
     * WARNING - void declaration
     */
    private String cascadeTargetRefName(Component comp) throws ConfigGenException {
        void var2_5;
        String targetRefName;
        TargetRef tr = comp.getLocalTargetRef();
        if (tr == null) {
            Component parent = comp.getExtendsType().getComponent();
            targetRefName = this.cascadeTargetRefName(parent);
        } else {
            try {
                TargetRef genTr = tr.generate(this);
                targetRefName = genTr.getHostName();
            }
            catch (ComponentDBException e) {
                throw new ConfigGenException(e);
            }
        }
        VariableSettingsHolder compVars = this.getCompVarHolder(comp);
        compVars.setVarValue(PREDEF_TARGET_REF_NAME, (String)var2_5);
        return var2_5;
    }

    private MachineInfo getMachineInfo() throws ConfigGenException {
        return this.getParentScope().getMachineInfo(PREDEF_RSRC_INSTALL_PATH);
    }

    private ConfigGenerator getParentScope() {
        return this.mParentScope;
    }

    private void setParentScope(ConfigGenerator parentScope) {
        this.mParentScope = parentScope;
    }

    private ConfigGenContext getContext() {
        return this.getParentScope().getContext();
    }

    private GeneratedVariableSettingsID getSaveID() {
        return this.mSaveID;
    }

    private void setSaveID(GeneratedVariableSettingsID saveID) {
        this.mSaveID = saveID;
    }

    private String getSaveName() {
        return this.mSaveName;
    }

    private void setSaveName(String saveName) {
        this.mSaveName = saveName;
    }

    public GeneratedVariableSettingsID saveSettings() throws RPCException, ConfigGenException {
        GeneratedVariableSettingsID saveID = this.getSaveID();
        if (saveID == null) {
            VariableSettingsManager varManager = this.getContext().getVarManager();
            VariableSettingsHolder varsToSave = this.getGeneratedVariables();
            saveID = varManager.saveVariableSettings(this.getSaveName(), varsToSave);
            this.setSaveID(saveID);
        }
        return saveID;
    }

    VariableSettingsHolder getGeneratedVariables() throws RPCException {
        VariableSettingsHolder varsToSave = new VariableSettingsHolder();
        Iterator allCompVars = this.mCompVarMap.entrySet().iterator();
        while (allCompVars.hasNext()) {
            Map.Entry entry = allCompVars.next();
            String key = entry.getKey().toString() + ':';
            VariableSettingsHolder compVars = (VariableSettingsHolder)entry.getValue();
            String[] varNames = compVars.getVarNames();
            for (int i = 0; i < varNames.length; ++i) {
                varsToSave.setVarValue(key + varNames[i], compVars.getVarValue(varNames[i]));
            }
        }
        return varsToSave;
    }

    public ConfigGenerator newCallerScope(Caller caller) throws ConfigGenException {
        if (caller == null) {
            throw ConfigGenException.noCallerScope();
        }
        Component comp = caller.getDeclaredComponent();
        if (comp == null) {
            throw ConfigGenException.noComponentInCallerScope();
        }
        VariableSettingsHolder vars = this.getCompVarHolder(comp);
        if (vars == null) {
            throw ConfigGenException.unrelatedComponentInCallerScope();
        }
        return new LocalConfigGenerator(this.getParentScope(), vars, false).newCallerScope(caller);
    }

    public static VariableSettingsSource getComponentVars(GeneratedVariableSettings vars, SummaryComponent comp) throws ConfigGenException {
        ComponentConfigManager gen = new ComponentConfigManager(ConfigGenerator.NO_OP_GENERATOR, vars);
        return gen.getCompVarHolder(comp);
    }
}

