/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.stickydata;

import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ItemExpiredEventHandler;
import com.raplix.rolloutexpress.command.stickydata.ItemID;
import com.raplix.rolloutexpress.command.stickydata.PackageInfo;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class Table {
    private Hashtable mTable = new Hashtable();

    public ItemID addItem(Object item, BagID bagID, Date expiration) {
        return this.addItem(item, bagID, expiration, null);
    }

    public ItemID addItem(Object item, BagID bagID, Date expiration, ItemExpiredEventHandler handler) {
        ItemID itemID = ItemID.generateItemID();
        this.mTable.put(itemID, new Entry(item, bagID, expiration, handler));
        return itemID;
    }

    public boolean hasItem(ItemID itemID) {
        return this.mTable.get(itemID) != null;
    }

    public Object getItem(ItemID itemID) {
        Entry e = (Entry)this.mTable.get(itemID);
        if (e != null) {
            return e.getItem();
        }
        throw PackageInfo.createUnknownItem(itemID);
    }

    public void removeItem(ItemID itemID) {
        this.mTable.remove(itemID);
    }

    public void removeInsideBag(BagID bagID) {
        this.removeInsideBags(new BagID[]{bagID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInsideBags(BagID[] bagIDs) {
        HashSet set = (HashSet)CollectionUtil.mapClass(bagIDs, HashSet.class);
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            Enumeration e = this.mTable.keys();
            while (e.hasMoreElements()) {
                ItemID itemID = (ItemID)e.nextElement();
                if (!set.contains(((Entry)this.mTable.get(itemID)).getBagID())) continue;
                this.mTable.remove(itemID);
            }
        }
    }

    public void removeOutsideBag(BagID bagID) {
        this.removeOutsideBags(new BagID[]{bagID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutsideBags(BagID[] bagIDs) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("current bags: " + this.mTable.size(), this);
            Logger.debug("Removing outside nBags: " + bagIDs.length + ", they are: " + Util.getStringFromArray(bagIDs, ","), this);
        }
        HashSet set = (HashSet)CollectionUtil.mapClass(bagIDs, HashSet.class);
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            Enumeration e = this.mTable.keys();
            while (e.hasMoreElements()) {
                ItemID itemID = (ItemID)e.nextElement();
                if (set.contains(((Entry)this.mTable.get(itemID)).getBagID())) continue;
                this.mTable.remove(itemID);
                if (!Logger.isDebugEnabled(this)) continue;
                Logger.debug("removing: " + itemID, this);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("after removal bagsLeft: " + this.mTable.size() + " and they are: " + this.toString(), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpired(Date cutoff) {
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            Enumeration e = this.mTable.keys();
            while (e.hasMoreElements()) {
                ItemID itemID = (ItemID)e.nextElement();
                Entry entry = (Entry)this.mTable.get(itemID);
                Date expiration = entry.getExpiration();
                if (expiration == null || !expiration.before(cutoff)) continue;
                this.mTable.remove(itemID);
                entry.expire(itemID);
            }
        }
    }

    public void removeExpired() {
        this.removeExpired(new Date());
    }

    public void removeAll() {
        this.mTable.clear();
    }

    public String toString() {
        return this.mTable.toString();
    }

    private static class Entry {
        private Object mItem;
        private BagID mBagID;
        private Date mExpiration;
        private ItemExpiredEventHandler mExpirationHandler;

        Entry(Object item, BagID bagID, Date expiration, ItemExpiredEventHandler handler) {
            this.mItem = item;
            this.mBagID = bagID;
            this.mExpiration = expiration;
            this.mExpirationHandler = handler;
        }

        Object getItem() {
            return this.mItem;
        }

        BagID getBagID() {
            return this.mBagID;
        }

        Date getExpiration() {
            return this.mExpiration;
        }

        public String toString() {
            return "[" + this.getItem() + ";" + this.getBagID() + ";" + this.getExpiration() + "]";
        }

        void expire(ItemID itemID) {
            if (this.mExpirationHandler != null) {
                this.mExpirationHandler.itemExpired(this.getItem(), itemID, this.getBagID());
            }
        }
    }
}

