/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.stickydata;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.SubsystemID;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ReaperContext;
import com.raplix.rolloutexpress.command.stickydata.StickyInterface;
import com.raplix.rolloutexpress.command.stickydata.Table;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.ContextThread;
import java.util.Hashtable;

public class StickySubsystem
extends Subsystem
implements StickyInterface {
    private static final String CFG_PREFIX = "stickyData.";
    private static final String CFG_VAR_REAPER = "reaperSecs";
    private static final String CFG_VAR_REAPER_VALUE = "300";
    private Hashtable mTables = new Hashtable();
    private ContextThread mReaperThread;

    private StickySubsystem() {
    }

    public StickySubsystem(Application app) throws ConfigurationException {
        super(app);
        this.mReaperThread = new ContextThread(new ReaperContext(new Context(StickySubsystem.class.getName()), this.getConfigurationAsInt(CFG_VAR_REAPER) * 1000, this.mTables));
        this.mReaperThread.setDaemon(true);
        this.mReaperThread.start();
    }

    protected String getConfigurationPropertyPrefix() {
        return CFG_PREFIX;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        if (this.mApplication == null) {
            return null;
        }
        return new DefaultConfiguration[]{new DefaultConfiguration(CFG_VAR_REAPER, CFG_VAR_REAPER_VALUE, "Reaper period in seconds")};
    }

    public void prepareForShutdown() {
        this.mReaperThread.abort();
    }

    public void removeInsideBag(SubsystemID subsystemID, BagID bagID) {
        this.getTable(subsystemID).removeInsideBag(bagID);
    }

    public void removeOutsideBags(SubsystemID subsystemID, BagID[] bagIDs) {
        this.getTable(subsystemID).removeOutsideBags(bagIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(SubsystemID subsystemID) {
        Table table;
        Hashtable hashtable = this.mTables;
        synchronized (hashtable) {
            table = (Table)this.mTables.get(subsystemID);
            if (table == null) {
                table = new Table();
                this.mTables.put(subsystemID, table);
            }
        }
        return table;
    }
}

