/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.util.file.XSLTTransform;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.stream.StreamSource;

class XSLTransformation
extends Transformation {
    private String mSerializedTransform = null;

    static XSLTransformation createFileTransform(String transformFile, String inFile, String outFile) {
        if (transformFile == null) {
            throw new NullPointerException();
        }
        return new XSLTransformation(transformFile, inFile, outFile);
    }

    static XSLTransformation createTransform(String transform, String inFile, String outFile) {
        if (transform == null) {
            throw new NullPointerException();
        }
        XSLTransformation xsl = new XSLTransformation(null, inFile, outFile);
        xsl.mSerializedTransform = transform;
        return xsl;
    }

    private XSLTransformation(String transformFile, String inFile, String outFile) {
        super(inFile, outFile, transformFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doTransform(Reader input, Writer output, Reader source) throws IOException, CommandExecutionErrorException {
        StringReader stringSource = null;
        try {
            if (source == null) {
                source = new StringReader(this.mSerializedTransform);
                stringSource = source;
            }
            XSLTTransform transform = new XSLTTransform(new StreamSource(source));
            transform.apply(input, output);
            Object var7_6 = null;
            if (stringSource == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (stringSource == null) throw throwable;
            try {
                ((Reader)stringSource).close();
                throw throwable;
            }
            catch (IOException ioe) {
                if (!Logger.isErrorEnabled(this)) throw throwable;
                Logger.error("Error closing string source", ioe, this);
            }
            throw throwable;
        }
        try {
            ((Reader)stringSource).close();
            return;
        }
        catch (IOException ioe) {
            if (!Logger.isErrorEnabled(this)) return;
            Logger.error("Error closing string source", ioe, this);
        }
    }
}

