/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import [Lcom.raplix.rolloutexpress.command.commandresult.ProcessSpec;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.CommandUtil;
import com.raplix.rolloutexpress.command.WindowsNativePlatformIntegration;
import com.raplix.rolloutexpress.command.commandresult.ProcessSpec;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.impl.NativePlatformIntegrationImpl;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.windows.WinProcessInfo;
import com.raplix.util.platform.windows.WindowsServices;
import com.raplix.util.regex.RegEx;
import com.raplix.util.string.StringUtil;
import java.util.Vector;

public class WindowsNativePlatformIntegrationImpl
extends NativePlatformIntegrationImpl {
    public WindowsNativePlatformIntegrationImpl(Application inApp, WindowsNativePlatformIntegration inNativeSubsystem) throws UnsupportedSubsystemException {
        super(inApp, inNativeSubsystem);
    }

    public ProcessSpec[] listProcesses(String inUser) throws CommandExecutionErrorException {
        RegEx user = null;
        if (!StringUtil.isEmpty(inUser)) {
            user = CommandUtil.createRegEx(inUser);
        }
        try {
            Vector info = WindowsServices.getInstance().getProcessInfo(user);
            Vector<ProcessSpec> processes = new Vector<ProcessSpec>();
            for (int i = 0; i < info.size(); ++i) {
                WinProcessInfo processInfo = (WinProcessInfo)info.get(i);
                ProcessSpec s = new ProcessSpec(processInfo.getOwnerUser(), (int)processInfo.getProcessID(), processInfo.getCommandLine());
                processes.addElement(s);
            }
            return (ProcessSpec[])CollectionUtil.mapClass(processes, ProcessSpec;.class);
        }
        catch (Exception ex) {
            throw new CommandExecutionErrorException("cmd.ERR_PS_CMD", (Throwable)ex, ex.getMessage());
        }
    }

    public void chmod(String inPath, int inOctet, boolean inIsRecursive) throws CommandExecutionErrorException {
        throw new CommandExecutionErrorException("cmd.ERR_OPERATION_NOT_SUPPORTED", (Object[])new String[]{"chmod"});
    }

    public void chown(String inPath, String inNewOwner, String inNewGroup, boolean inIsRecursive) throws CommandExecutionErrorException {
        throw new CommandExecutionErrorException("cmd.ERR_OPERATION_NOT_SUPPORTED", (Object[])new String[]{"chown"});
    }

    public void chgrp(String inPath, String inGroup, boolean inIsRecursive) throws CommandExecutionErrorException {
        throw new CommandExecutionErrorException("cmd.ERR_OPERATION_NOT_SUPPORTED", (Object[])new String[]{"chgrp"});
    }

    protected void doReboot() throws CommandExecutionErrorException {
        try {
            WindowsServices.getInstance().doReboot();
        }
        catch (Exception ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Reboot failed", ex, this);
            }
            throw new CommandExecutionErrorException("cmd.ERR_REBOOT_CMD", (Throwable)ex, ex.getMessage());
        }
    }
}

