/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.impl.PerlTransformation;
import com.raplix.rolloutexpress.command.impl.XSLTransformation;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.plandb.PerlSub;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.iowrappers.AtomicOutput;
import com.raplix.util.iowrappers.GeneralizedFile;
import com.raplix.util.logger.Logger;
import com.raplix.util.unicode.UnicodeFileReader;
import com.raplix.util.unicode.UnicodeFileWriter;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import com.raplix.util.unicode.UnicodeOutputStreamWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public abstract class Transformation
implements RPCSerializable {
    private String mInFile;
    private String mOutFile;
    private String mSourceFile;

    public static Transformation perlTransform(PerlSub[] transforms, String inFile, String outFile) {
        return new PerlTransformation(transforms, inFile, outFile);
    }

    public static Transformation perlTransform(String transformFile, String inFile, String outFile) {
        return new PerlTransformation(transformFile, inFile, outFile);
    }

    public static Transformation xslTransform(String transform, String inFile, String outFile) {
        return XSLTransformation.createTransform(transform, inFile, outFile);
    }

    public static Transformation xslFileTransform(String transformFile, String inFile, String outFile) {
        return XSLTransformation.createFileTransform(transformFile, inFile, outFile);
    }

    public static Transformation copyTransform(String inFile, String outFile) {
        return new CopyTransformation(inFile, outFile);
    }

    protected Transformation(String inFile, String outFile, String inSourceFile) {
        if (inFile == null) {
            throw new NullPointerException();
        }
        this.mInFile = inFile;
        this.mOutFile = outFile;
        this.mSourceFile = inSourceFile;
    }

    private Transformation() {
    }

    /*
     * Loose catch block
     */
    void transformFile() throws CommandExecutionErrorException {
        block48: {
            IOException ioe2222;
            GeneralizedFile outputFile;
            GeneralizedFile inputFile;
            AtomicOutput output;
            UnicodeOutputStreamWriter writer;
            UnicodeInputStreamReader reader;
            UnicodeFileReader source;
            block42: {
                block41: {
                    block40: {
                        source = null;
                        reader = null;
                        writer = null;
                        output = null;
                        inputFile = null;
                        outputFile = null;
                        source = this.mSourceFile != null ? new UnicodeFileReader(this.mSourceFile) : null;
                        inputFile = new GeneralizedFile(this.mInFile);
                        if (!inputFile.getExists()) {
                            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_FOUND", this.mInFile));
                        }
                        inputFile.setReadOnly(true);
                        reader = new UnicodeFileReader(inputFile.getFile());
                        outputFile = new GeneralizedFile(this.mOutFile == null ? this.mInFile : this.mOutFile);
                        output = new AtomicOutput(outputFile.getFile(), true);
                        writer = new UnicodeFileWriter(output.getOutput(), (Reader)reader);
                        this.doTransform(reader, writer, source);
                        output.setValid(true);
                        Object var9_7 = null;
                        if (source == null) break block40;
                        try {
                            source.close();
                        }
                        catch (IOException ioe2222) {
                            if (!Logger.isErrorEnabled(this)) break block40;
                            Logger.error("Error closing source file", ioe2222, this);
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe2222) {
                            if (!Logger.isErrorEnabled(this)) break block41;
                            Logger.error("Error closing input file", ioe2222, this);
                        }
                    }
                }
                if (inputFile != null) {
                    try {
                        inputFile.close();
                    }
                    catch (IOException ioe2222) {
                        if (!Logger.isErrorEnabled(this)) break block42;
                        Logger.error("Error closing generalized input file", ioe2222, this);
                    }
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe2222) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error closing output", ioe2222, this);
                    }
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe2222);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ioe2222) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error copying output from temporary file to destination", ioe2222, this);
                    }
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe2222);
                }
            }
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException ioe2222) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error stuffing output into generalized file", ioe2222, this);
                    }
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe2222);
                }
            }
            break block48;
            {
                catch (IOException ioe3) {
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe3);
                }
            }
            catch (Throwable throwable) {
                IOException ioe2222;
                block47: {
                    block46: {
                        block45: {
                            Object var9_8 = null;
                            if (source != null) {
                                try {
                                    source.close();
                                }
                                catch (IOException ioe2222) {
                                    if (!Logger.isErrorEnabled(this)) break block45;
                                    Logger.error("Error closing source file", ioe2222, this);
                                }
                            }
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ioe2222) {
                                if (!Logger.isErrorEnabled(this)) break block46;
                                Logger.error("Error closing input file", ioe2222, this);
                            }
                        }
                    }
                    if (inputFile != null) {
                        try {
                            inputFile.close();
                        }
                        catch (IOException ioe2222) {
                            if (!Logger.isErrorEnabled(this)) break block47;
                            Logger.error("Error closing generalized input file", ioe2222, this);
                        }
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe2222) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error closing output", ioe2222, this);
                        }
                        throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe2222);
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException ioe2222) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error copying output from temporary file to destination", ioe2222, this);
                        }
                        throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe2222);
                    }
                }
                if (outputFile != null) {
                    try {
                        outputFile.close();
                    }
                    catch (IOException ioe2222) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error stuffing output into generalized file", ioe2222, this);
                        }
                        throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_TRANSFORM"), (Throwable)ioe2222);
                    }
                }
                throw throwable;
            }
        }
    }

    public File getInputFile() {
        return this.mInFile != null ? new File(this.mInFile) : null;
    }

    public File getSourceFile() {
        return this.mSourceFile != null ? new File(this.mSourceFile) : null;
    }

    public File getOutputFile() {
        return this.mOutFile != null ? new File(this.mOutFile) : null;
    }

    protected abstract void doTransform(Reader var1, Writer var2, Reader var3) throws IOException, CommandExecutionErrorException;

    private static class CopyTransformation
    extends Transformation {
        CopyTransformation(String inFile, String outFile) {
            super(inFile, outFile, null);
        }

        protected void doTransform(Reader input, Writer output, Reader source) throws IOException {
            CopyUtil.copyText(input, output);
        }
    }
}

