/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.CommandUtil;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.ConnectivityException;
import com.raplix.rolloutexpress.command.exceptions.PatternMismatchException;
import com.raplix.rolloutexpress.command.exceptions.URLAccessException;
import com.raplix.rolloutexpress.command.impl.CommandImpl;
import com.raplix.rolloutexpress.command.rpcinterfaces.ExecJavaStepDescriptor;
import com.raplix.rolloutexpress.command.rpcinterfaces.ToolsInterface;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.HostNotFound;
import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.plugin.ExecJavaExecutor;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.RegEx;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class ToolsInterfaceImpl
extends CommandImpl
implements ToolsInterface,
CommandMessages {
    private static final int MILLIS_SEC = 1000;

    protected ToolsInterfaceImpl(Application inApp) {
        super(inApp);
    }

    public boolean checkConnectivity(RoxAddress inTargetAddr) throws ConnectivityException, RPCException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Pinging destination:" + inTargetAddr, this);
        }
        try {
            RoxAddress destAddress = inTargetAddr;
            PingResult pr = this.mApplication.getNetSubsystem().getTransport().getControl().ping(destAddress);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Pinged with result:" + pr, this);
            }
            return pr.isSuccess();
        }
        catch (TransportException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Transport error while pinging", ex, this);
            }
            throw new ConnectivityException(new ROXMessage("cmd.DFLT_PROVIDER_PING_ERR"), (Throwable)ex);
        }
        catch (HostNotFound hnf) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Transport error while pinging", hnf, this);
            }
            throw new ConnectivityException(new ROXMessage("cmd.DFLT_PROVIDER_PING_ERR"), (Throwable)hnf);
        }
    }

    public String getAgentUser() {
        return this.mApplication.getSystemUser();
    }

    public void checkURL(String inSourceURL, String inSafeURL, String inPattern, int inDelaySecs, int inTimeoutSecs) throws URLAccessException, PatternMismatchException, RPCException {
        int nTriesLeft = inTimeoutSecs / inDelaySecs;
        if (nTriesLeft == 0) {
            nTriesLeft = 1;
        }
        RegEx patternRE = CommandUtil.createRegEx(inPattern);
        try {
            URL url = new URL(inSourceURL);
            for (int attempt = 0; attempt < nTriesLeft; ++attempt) {
                block14: {
                    try {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("checkURL attempt: " + attempt, this);
                        }
                        this.checkURLHelper(url, inSafeURL, patternRE);
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("found pattern " + inPattern + " at url " + inSafeURL, this);
                        }
                        return;
                    }
                    catch (URLAccessException ex) {
                        if (attempt == nTriesLeft - 1) {
                            throw ex;
                        }
                    }
                    catch (PatternMismatchException ex) {
                        if (attempt != nTriesLeft - 1) break block14;
                        throw ex;
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(inDelaySecs * 1000);
                    continue;
                }
                catch (InterruptedException ex) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Interrupted while waiting in checkURL", this);
                    }
                    break;
                }
            }
        }
        catch (MalformedURLException muex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Malformed URL: " + inSafeURL, this);
            }
            throw new URLAccessException("cmd.ERR_INAVLID_URL", inSafeURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkURLHelper(URL url, String inSafeURL, RegEx inPatternRE) throws URLAccessException, PatternMismatchException {
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Checking url " + inSafeURL + " for pattern " + inPatternRE.toString(), this);
            }
            InputStream theInputStream = url.openStream();
            String thePageStr = null;
            try {
                int len;
                byte[] buf = new byte[2048];
                StringBuffer thePage = new StringBuffer();
                while ((len = theInputStream.read(buf)) != -1) {
                    thePage.append(new String(buf, 0, len));
                }
                thePageStr = thePage.toString();
            }
            finally {
                theInputStream.close();
            }
            if (!inPatternRE.match(thePageStr)) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("regex not found", this);
                }
                throw new PatternMismatchException("cmd.URL_PATTERN_NO_MATCH", inSafeURL, inPatternRE.toString());
            }
        }
        catch (IOException ioex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to successfully check URL: ", ioex, this);
            }
            throw new URLAccessException("cmd.ERR_CHECK_URL", (Throwable)ioex, new Object[]{inSafeURL, inPatternRE.toString()});
        }
    }

    public ExecNativeOutput execJava(ExecJavaStepDescriptor inJava) throws CommandExecutionErrorException, RPCException {
        ExecJavaExecutor eje = new ExecJavaExecutor(this.mApplication, inJava);
        eje.execute();
        return eje.getFinalOutput();
    }
}

