/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.rpcinterfaces.SnapshotServices;
import com.raplix.rolloutexpress.executor.ServerBootID;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotPurgeData;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotSet;
import com.raplix.rolloutexpress.executor.task.DirectoryListing;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.capture.ContentsTableEntry;
import com.raplix.rolloutexpress.resource.capture.OwnedCaptureType;
import com.raplix.rolloutexpress.resource.capture.SnapshotContentsTable;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTable;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTableEntry;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTransaction;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotFilter;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotOwnership;
import com.raplix.util.file.FileInfo;
import com.raplix.util.file.FileUtil;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.Link;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;

public class SnapshotImpl
implements SnapshotServices,
CommandMessages {
    private Application mApp;
    private long mRequestID;
    private ServerBootID mServerBootID;

    public SnapshotImpl(Application inApp) {
        this.mApp = inApp;
    }

    public void snapshot(final SnapshotPurgeData inPurgeData, final SnapshotSet inSnapshotSet) throws RPCException, CommandExecutionErrorException {
        try {
            final Enumeration directives = inSnapshotSet.getSnapshotDirectivesReverseOrder();
            ResourceSubsystem rSubsystem = this.mApp.getResourceSubsystem();
            final SnapshotContentsTable contentsTable = rSubsystem.getSnapshotContentsTable();
            final PathSet pathSet = new PathSet();
            SnapshotOwnerTransaction ownerTransaction = new SnapshotOwnerTransaction(rSubsystem){

                public Object innerTransact(SnapshotOwnerTable inOwnerTable) throws CaptureException {
                    try {
                        SnapshotImpl.this.purgeOrphanedSnapshots(inPurgeData, inOwnerTable, contentsTable);
                        SnapshotSet.SnapshotDirective directive = null;
                        File path = null;
                        while (directives.hasMoreElements()) {
                            directive = (SnapshotSet.SnapshotDirective)directives.nextElement();
                            path = new File(SnapshotImpl.removeTrailingSeparator(directive.getPath()));
                            try {
                                FileInfo info = new FileInfo(path);
                                if (info.isLink()) {
                                    SnapshotImpl.addDirective(inOwnerTable, path, path, inSnapshotSet, directive.getOwnership(), OwnedCaptureType.LINK_VALUE, pathSet, directive.getDisplayName());
                                    continue;
                                }
                                if (!path.exists()) {
                                    if (directive.getDisplayName() == null) {
                                        throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE_RH", (Object[])new String[]{path.getAbsolutePath()});
                                    }
                                    throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE", (Object[])new String[]{path.getAbsolutePath(), directive.getDisplayName()});
                                }
                                path = FileUtil.getAbsoluteNormalizedFile(path);
                                if (info.isDirectory()) {
                                    SnapshotImpl.addDirectory(inOwnerTable, directive, path, inSnapshotSet, pathSet);
                                    continue;
                                }
                                if (!info.isPlain()) continue;
                                SnapshotImpl.addDirective(inOwnerTable, path, path, inSnapshotSet, directive.getOwnership(), OwnedCaptureType.FILE_CONTENTS, pathSet, directive.getDisplayName());
                            }
                            catch (IllegalArgumentException e) {
                                if (directive.getDisplayName() == null) {
                                    throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE_RH", (Throwable)e, (Object[])new String[]{path.getAbsolutePath()});
                                }
                                throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE", (Throwable)e, (Object[])new String[]{path.getAbsolutePath(), directive.getDisplayName()});
                            }
                        }
                        contentsTable.put(inSnapshotSet.getSnapshotID(), pathSet.getEntries());
                    }
                    catch (IOException ioe) {
                        throw new CaptureException("cmd.ERR_CAPTURE_SNAPSHOT", (Throwable)ioe);
                    }
                    return null;
                }
            };
            ownerTransaction.transact();
        }
        catch (CaptureException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_CAPTURE_SNAPSHOT"), (Throwable)ce);
        }
        catch (UnsupportedSubsystemException use) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_CAPTURE_SNAPSHOT"), (Throwable)use);
        }
    }

    public static String removeTrailingSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirectory(SnapshotOwnerTable inTable, SnapshotSet.SnapshotDirective inDirective, File inFile, SnapshotSet inSnapshotSet, PathSet pathSet) throws IOException, CaptureException, IllegalArgumentException {
        File[] directories;
        FileInfo info;
        int i;
        File[] files;
        TempFile listing;
        if ((inDirective.getFilter().equals(SnapshotFilter.BOTH) || inDirective.getFilter().equals(SnapshotFilter.DIRECTORIES)) && !pathSet.contains(inFile) && (listing = SnapshotImpl.getDirListing(inFile)) != null) {
            try {
                SnapshotImpl.addDirective(inTable, inFile, listing.getFile(), inSnapshotSet, inDirective.getOwnership(), OwnedCaptureType.DIR_LISTING, pathSet, inDirective.getDisplayName());
            }
            finally {
                listing.close();
            }
        }
        if ((inDirective.getFilter().equals(SnapshotFilter.BOTH) || inDirective.getFilter().equals(SnapshotFilter.FILES)) && (files = inFile.listFiles()) != null) {
            for (i = 0; i < files.length; ++i) {
                OwnedCaptureType captureType;
                info = new FileInfo(files[i]);
                if (info.isLink()) {
                    captureType = OwnedCaptureType.LINK_VALUE;
                } else {
                    if (!info.isPlain()) continue;
                    captureType = OwnedCaptureType.FILE_CONTENTS;
                }
                SnapshotImpl.addDirective(inTable, files[i], files[i], inSnapshotSet, inDirective.getOwnership(), captureType, pathSet, inDirective.getDisplayName());
            }
        }
        if (inDirective.getIsRecursive() && (directories = inFile.listFiles()) != null) {
            for (i = 0; i < directories.length; ++i) {
                info = new FileInfo(directories[i]);
                if (info.isLink() || !info.isDirectory()) continue;
                SnapshotImpl.addDirectory(inTable, inDirective, directories[i], inSnapshotSet, pathSet);
            }
        }
    }

    public static TempFile getDirListing(File dirpath) throws IOException, IllegalArgumentException {
        DirectoryListing listing = DirectoryListing.generate(dirpath);
        if (listing != null) {
            TempFile minidb = new TempFile("dirlist", ".mdb");
            listing.writeTo(minidb.getFile());
            return minidb;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirective(SnapshotOwnerTable inTable, File name, File contents, SnapshotSet inSnapshotSet, SnapshotOwnership inOwnership, OwnedCaptureType inCaptureType, PathSet pathSet, String inDisplayName) throws IOException, CaptureException {
        block15: {
            if (Logger.isDebugEnabled(SnapshotImpl.class)) {
                Logger.debug("addDirective:" + name + " with displayName: " + inDisplayName, SnapshotImpl.class);
            }
            if (pathSet.contains(name)) {
                if (Logger.isDebugEnabled(SnapshotImpl.class)) {
                    Logger.debug("skipping:" + name, SnapshotImpl.class);
                }
                return;
            }
            InputStream inStream = null;
            try {
                inStream = OwnedCaptureType.LINK_VALUE.equals(inCaptureType) ? new ByteArrayInputStream(Link.read(contents.getAbsolutePath()).getBytes()) : new FileInputStream(contents);
            }
            catch (IllegalArgumentException iae) {
                if (inDisplayName == null) {
                    throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE_RH", (Throwable)iae, (Object[])new String[]{contents.getAbsolutePath()});
                }
                throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE", (Throwable)iae, (Object[])new String[]{contents.getAbsolutePath(), inDisplayName});
            }
            catch (FileNotFoundException fnf) {
                if (inDisplayName == null) {
                    throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE_RH", (Throwable)fnf, (Object[])new String[]{contents.getAbsolutePath()});
                }
                throw new CaptureException("cmd.ERR_CAPTURE_SNAP_FILE_DNE", (Throwable)fnf, (Object[])new String[]{contents.getAbsolutePath(), inDisplayName});
            }
            try {
                if (inOwnership.equals(SnapshotOwnership.ADD_SELF)) {
                    SnapshotImpl.addSelf(inTable, name.getAbsolutePath(), inStream, inSnapshotSet, inCaptureType);
                    break block15;
                }
                if (inOwnership.equals(SnapshotOwnership.SET_SELF)) {
                    SnapshotImpl.setSelf(inTable, name.getAbsolutePath(), inStream, inSnapshotSet, inCaptureType);
                    break block15;
                }
                if (inOwnership.equals(SnapshotOwnership.ADD_TEMP)) {
                    SnapshotImpl.addTemp(inTable, name.getAbsolutePath(), inStream, inSnapshotSet, inCaptureType);
                    break block15;
                }
                throw new IllegalArgumentException("Invalid ownership type:" + inOwnership);
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
        pathSet.add(new ContentsTableEntry(name.getAbsolutePath(), inCaptureType, inDisplayName));
    }

    private static void addSelf(SnapshotOwnerTable inTable, String name, InputStream contents, SnapshotSet inSnapshotSet, OwnedCaptureType inType) throws CaptureException {
        SnapshotOwnerTableEntry[] tableEntries = inTable.queryByName(name);
        if (tableEntries != null && tableEntries.length > 0) {
            inTable.insertAdd(name, inSnapshotSet.getInstalledComponentID(), inSnapshotSet.getSnapshotID(), tableEntries[0].getOwnedCaptureID());
        } else {
            inTable.insertSet(name, inSnapshotSet.getInstalledComponentID(), inSnapshotSet.getSnapshotID(), inType, contents);
        }
    }

    private static void setSelf(SnapshotOwnerTable inTable, String name, InputStream contents, SnapshotSet inSnapshotSet, OwnedCaptureType inType) throws CaptureException {
        inTable.deleteEntriesByName(name);
        inTable.insertSet(name, inSnapshotSet.getInstalledComponentID(), inSnapshotSet.getSnapshotID(), inType, contents);
    }

    private static void addTemp(SnapshotOwnerTable inTable, String name, InputStream contents, SnapshotSet inSnapshotSet, OwnedCaptureType inType) throws CaptureException {
        inTable.insertSet(name, inSnapshotSet.getInstalledComponentID(), inSnapshotSet.getSnapshotID(), inType, contents);
    }

    public void purgeSnapshots(final SnapshotPurgeData inPurgeData) throws RPCException, CommandExecutionErrorException {
        try {
            ResourceSubsystem rSubsystem = this.mApp.getResourceSubsystem();
            final SnapshotContentsTable contentsTable = rSubsystem.getSnapshotContentsTable();
            SnapshotOwnerTransaction ownerTransaction = new SnapshotOwnerTransaction(rSubsystem){

                public Object innerTransact(SnapshotOwnerTable inOwnerTable) throws CaptureException {
                    SnapshotImpl.this.purgeOrphanedSnapshots(inPurgeData, inOwnerTable, contentsTable);
                    return null;
                }
            };
            ownerTransaction.transact();
        }
        catch (UnsupportedSubsystemException use) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_REMOVE_SNAPSHOT"), (Throwable)use);
        }
        catch (CaptureException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_REMOVE_SNAPSHOT"), (Throwable)ce);
        }
    }

    private void purgeOrphanedSnapshots(SnapshotPurgeData inPurgeData, SnapshotOwnerTable inOwnerTable, SnapshotContentsTable inContentsTable) throws CaptureException {
        if (this.mRequestID >= inPurgeData.getRequestID() && inPurgeData.getServerBootID().equals(this.mServerBootID)) {
            return;
        }
        inOwnerTable.purgeOrphanedEntries(inPurgeData.getInstalledComps());
        inContentsTable.purgeOrphanedEntries(inPurgeData.getInstalledSnaps());
        this.mRequestID = inPurgeData.getRequestID();
        this.mServerBootID = inPurgeData.getServerBootID();
    }

    private static class PathSet {
        private HashSet paths = new HashSet();
        private LinkedList contents = new LinkedList();

        private PathSet() {
        }

        public void add(ContentsTableEntry entry) {
            this.paths.add(entry.getEntryName());
            this.contents.add(entry);
        }

        public boolean contains(File path) {
            return this.paths.contains(path.getAbsolutePath());
        }

        public ContentsTableEntry[] getEntries() {
            return this.contents.toArray(new ContentsTableEntry[this.contents.size()]);
        }
    }
}

