/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.command.commandresult.ExecNativeResult;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.NativeCommandNotExecutableException;
import com.raplix.rolloutexpress.command.impl.ExecNativeDescriptor;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimpleExecNativeDescriptor
extends ExecNativeDescriptor {
    private String mCommand;
    private String[] mCmdArray;
    private ExecNativeResult mResult;
    private transient ByteArrayOutputStream mStdOut;
    private transient ByteArrayOutputStream mStdErr;

    private SimpleExecNativeDescriptor() {
    }

    public SimpleExecNativeDescriptor(String command, long timeout) {
        super(timeout);
        this.mCommand = command;
        this.mCmdArray = Util.parseCommandLine(command);
    }

    public RPCSerializable getResult() {
        return this.mResult;
    }

    protected OutputStream getOutput() {
        this.mStdOut = new ByteArrayOutputStream();
        return this.mStdOut;
    }

    protected String getCommandStringForErrMsg() {
        return this.mCommand;
    }

    protected void postProcess() throws CommandExecutionErrorException {
        this.mResult = new ExecNativeResult((int)this.getExitStatus(), this.mStdOut.toString(), this.mStdErr.toString());
    }

    protected Process createProcess() throws CommandExecutionErrorException {
        try {
            return Runtime.getRuntime().exec(this.mCmdArray);
        }
        catch (IOException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ex.getMessage(), this);
            }
            throw new NativeCommandNotExecutableException(ex, ex.getMessage(), this.getCommandStringForErrMsg());
        }
    }

    protected InputStream getInput() throws CommandExecutionErrorException {
        return new ByteArrayInputStream(new byte[0]);
    }

    protected OutputStream getError() throws CommandExecutionErrorException {
        this.mStdErr = new ByteArrayOutputStream();
        return this.mStdErr;
    }
}

