/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.exceptions.InvalidUserGroupException;
import com.raplix.rolloutexpress.command.exceptions.RANoRootPrivilegesException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceProcess;
import com.raplix.rolloutexpress.resource.exception.ResourceProcessException;
import com.raplix.util.Security;
import com.raplix.util.file.RecursiveChown;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.File;

public class ResourcePermissionSetter
extends ResourceProcess
implements CommandMessages {
    private String mInstallUser = null;
    private String mInstallGroup = null;
    private String mParentDirUser = null;
    private String mParentDirGroup = null;
    private int mInstallPermissions = 0;

    public ResourcePermissionSetter(String inInstallUser, String inInstallGroup, int inInstallPermissions, String inDefaultParentUser, String inDefaultParentGroup) throws InvalidUserGroupException, RANoRootPrivilegesException {
        this.mInstallUser = inInstallUser;
        this.mInstallGroup = inInstallGroup;
        this.setInstallPermissions(inInstallPermissions);
        this.mParentDirUser = this.verifyUserValid(inDefaultParentUser);
        this.mParentDirGroup = this.verifyGroupValid(inDefaultParentGroup);
    }

    protected String preparePath(String inString) {
        return inString;
    }

    protected String verifyUserValid(String ioInstallUser) throws InvalidUserGroupException, RANoRootPrivilegesException {
        if (!StringUtil.isEmpty(ioInstallUser)) {
            if (!Security.isUserValid(ioInstallUser)) {
                throw new InvalidUserGroupException(new ROXMessage("cmd.ERR_USER_INVALID", new Object[]{ioInstallUser}));
            }
            if (Security.isProcessOwnerSameAsUser(ioInstallUser)) {
                ioInstallUser = null;
            } else if (!Security.isRootOrHasSetuidPrivileges()) {
                throw new RANoRootPrivilegesException();
            }
        } else {
            ioInstallUser = null;
        }
        return ioInstallUser;
    }

    protected String verifyGroupValid(String ioInstallGroup) throws InvalidUserGroupException, RANoRootPrivilegesException {
        if (!StringUtil.isEmpty(ioInstallGroup)) {
            if (!Security.isGroupValid(ioInstallGroup)) {
                throw new InvalidUserGroupException(new ROXMessage("cmd.ERR_GROUP_INVALID", new Object[]{ioInstallGroup}));
            }
            if (Security.isProcessGroupSameAsGroup(ioInstallGroup)) {
                ioInstallGroup = null;
            } else if (!Security.isRootOrHasSetuidPrivileges()) {
                throw new RANoRootPrivilegesException();
            }
        } else {
            ioInstallGroup = null;
        }
        return ioInstallGroup;
    }

    protected void setInstallPermissions(int inInstallPermissions) {
        this.mInstallPermissions = inInstallPermissions;
    }

    protected String getInstallUser() {
        if (null == this.mInstallUser || 0 == this.mInstallUser.length()) {
            return null;
        }
        return this.mInstallUser;
    }

    protected String getInstallGroup() {
        if (null == this.mInstallGroup || 0 == this.mInstallGroup.length()) {
            return null;
        }
        return this.mInstallGroup;
    }

    protected int getInstallPermissions() {
        return this.mInstallPermissions;
    }

    public void afterEnclosingDirCreations(ResourceID inResourceID, File inResourceDstRoot, File inEnclosingDir) throws ResourceProcessException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Changing perms for parent dir: " + inEnclosingDir.getAbsolutePath(), this);
        }
        if (null != this.mParentDirUser || null != this.mParentDirGroup) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Changing " + inEnclosingDir.getAbsolutePath() + " user to " + this.mParentDirUser, this);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Changing " + inEnclosingDir.getAbsolutePath() + " group to " + this.mParentDirGroup, this);
            }
            this.performChownChgrp(this.preparePath(inEnclosingDir.getAbsolutePath()), this.mParentDirUser, this.mParentDirGroup);
        }
    }

    protected void performChownChgrp(String inPath, String inInstallUser, String inInstallGroup) throws ResourceProcessException {
        try {
            RecursiveChown.change(inPath, inInstallUser, inInstallGroup, false, false, true);
        }
        catch (IllegalArgumentException ex) {
            throw new ResourceProcessException("cmd.ERR_CHNG_PERMS_PARENT_DIR", (Throwable)ex, (Object[])new String[]{inPath});
        }
    }
}

