/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.exceptions.InvalidUserGroupException;
import com.raplix.rolloutexpress.command.exceptions.RANoRootPrivilegesException;
import com.raplix.rolloutexpress.command.impl.ToolsInterfaceImpl;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.util.Security;
import com.raplix.util.platform.posix.Passwd;
import com.raplix.util.string.StringUtil;

public class PosixToolsInterfaceImpl
extends ToolsInterfaceImpl {
    public PosixToolsInterfaceImpl(Application inApp) {
        super(inApp);
    }

    public boolean shouldSpecifyUserToRunAs(String inUserToRunAs) throws RANoRootPrivilegesException, InvalidUserGroupException {
        if (!StringUtil.isEmpty(inUserToRunAs)) {
            Passwd userToRunAsPasswd = Security.createPasswd(inUserToRunAs);
            if (userToRunAsPasswd == null) {
                throw new InvalidUserGroupException(new ROXMessage("pe.INVALID_USER", inUserToRunAs));
            }
            if (!Security.isProcessOwnerSameAsUser(inUserToRunAs)) {
                if (!Security.isRootOrHasSetuidPrivileges()) {
                    throw new RANoRootPrivilegesException();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isUserValid(String inUser) {
        return Security.isUserValid(inUser);
    }
}

