/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.CommandUtil;
import com.raplix.rolloutexpress.command.PosixNativePlatformIntegration;
import com.raplix.rolloutexpress.command.commandresult.ExecNativeResult;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.commandresult.ProcessSpec;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.NativeCommandErrorException;
import com.raplix.rolloutexpress.command.impl.NativePlatformIntegrationImpl;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.util.file.RecursiveChmod;
import com.raplix.util.file.RecursiveChown;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.RegEx;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PosixNativePlatformIntegrationImpl
extends NativePlatformIntegrationImpl {
    public PosixNativePlatformIntegrationImpl(Application inApp, PosixNativePlatformIntegration inNativeSubsystem) throws UnsupportedSubsystemException {
        super(inApp, inNativeSubsystem);
    }

    public ProcessSpec[] listProcesses(String inUser) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        RegEx userRE = null;
        try {
            boolean fCheckUser;
            int parseCmdOffset;
            String commandLine = null;
            try {
                commandLine = ((PosixNativePlatformIntegration)this.mNativeSubsystem).getConfigFullProcessListCommand();
                parseCmdOffset = ((PosixNativePlatformIntegration)this.mNativeSubsystem).getConfigParseCmdOffset();
            }
            catch (ConfigurationException ex) {
                ROXMessage msg = new ROXMessage("cmd.ERR_PROC_CMD_CONFIG");
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(msg.toString(), ex, this);
                }
                throw new NativeCommandErrorException("cmd.ERR_PROC_CMD_CONFIG", (Throwable)ex);
            }
            ExecNativeResult result = this.execNative(commandLine);
            if (result == null || result.getExitValue() != 0) {
                ROXMessage msg = new ROXMessage("cmd.ERR_PS_CMD", result.getErrorOutput());
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(msg.toString(), this);
                }
                throw new NativeCommandErrorException(msg);
            }
            String theResult = result.getOutput();
            Vector<ProcessSpec> processes = new Vector<ProcessSpec>();
            StringTokenizer lines = new StringTokenizer(theResult, "\n");
            lines.nextToken();
            boolean bl = fCheckUser = inUser != null && inUser.length() > 0;
            if (fCheckUser) {
                userRE = CommandUtil.createRegEx(inUser);
            }
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                if (line.length() >= parseCmdOffset) {
                    try {
                        ProcessSpec theSpec = ProcessSpec.parsePSOutputLine(line, parseCmdOffset);
                        if (fCheckUser && (userRE == null || !userRE.match(theSpec.getUser()))) continue;
                        processes.addElement(theSpec);
                        continue;
                    }
                    catch (NoSuchElementException nseex) {
                        throw new CommandExecutionErrorException("cmd.ERR_PARSE_PS_OUTPUT", (Throwable)nseex, line);
                    }
                }
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn(new ROXMessage("cmd.ERR_PARSE_PS_OUTPUT", line).toString(), this);
            }
            Object[] resultArray = new ProcessSpec[processes.size()];
            processes.copyInto(resultArray);
            return resultArray;
        }
        catch (Exception ex) {
            throw new CommandExecutionErrorException("cmd.ERR_PS_CMD", (Throwable)ex);
        }
    }

    public void chmod(String inPath, int inOctet, boolean inIsRecursive) throws NativeCommandErrorException, CommandExecutionErrorException {
        if (inPath == null) {
            throw new CommandExecutionErrorException("cmd.INVALID_INCOMING_PATH_NULL");
        }
        inPath = FileSpec.convertPathSeparatorToLocal(inPath);
        try {
            RecursiveChmod.change(inPath, inOctet, inIsRecursive);
        }
        catch (Throwable ex) {
            ROXMessage msg = new ROXMessage("cmd.ERR_CHMOD_FAILED", new Object[]{Integer.toString(inOctet, 8), inPath, ex.getMessage()});
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg.toString(), ex, this);
            }
            throw new NativeCommandErrorException(msg, ex);
        }
    }

    public void chown(String inPath, String inNewOwner, String inNewGroup, boolean inIsRecursive) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        if (inPath == null) {
            throw new CommandExecutionErrorException("cmd.INVALID_INCOMING_PATH_NULL");
        }
        if (inNewOwner == null) {
            throw new CommandExecutionErrorException("cmd.ERR_CHOWN_OWNER_NULL");
        }
        if (!new File(inPath = FileSpec.convertPathSeparatorToLocal(inPath)).exists()) {
            throw new CommandExecutionErrorException("cmd.ERR_CHOWN_FILE_DNE", inPath);
        }
        try {
            RecursiveChown.change(inPath, inNewOwner, inNewGroup, inIsRecursive, false);
        }
        catch (Throwable ex) {
            ROXMessage msg = new ROXMessage("cmd.ERR_CHOWN_FAILED", new Object[]{inNewOwner, inPath, ex.getMessage()});
            throw new NativeCommandErrorException(msg, ex);
        }
    }

    public void chgrp(String inPath, String inGroup, boolean inIsRecursive) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        if (inPath == null) {
            throw new CommandExecutionErrorException("cmd.INVALID_INCOMING_PATH_NULL");
        }
        if (inGroup == null) {
            throw new CommandExecutionErrorException("cmd.ERR_CHGRP_GROUP_NULL");
        }
        inPath = FileSpec.convertPathSeparatorToLocal(inPath);
        try {
            RecursiveChown.change(inPath, null, inGroup, inIsRecursive, false);
        }
        catch (Throwable ex) {
            ROXMessage msg = new ROXMessage("cmd.ERR_CHOWN_FAILED", new Object[]{inGroup, inPath, ex.getMessage()});
            throw new NativeCommandErrorException(msg, ex);
        }
    }

    protected void doReboot() throws CommandExecutionErrorException {
        throw new CommandExecutionErrorException("cmd.ERR_OPERATION_NOT_SUPPORTED", new Object[]{"reboot"});
    }
}

