/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.rolloutexpress.systemmodel.plandb.PerlSub;
import com.raplix.util.file.Perl5Transform;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.xml.sax.InputSource;

class PerlTransformation
extends Transformation {
    private PerlSub[] mTransforms = null;

    PerlTransformation(PerlSub[] transforms, String inFile, String outFile) {
        super(inFile, outFile, null);
        if (transforms == null) {
            throw new NullPointerException();
        }
        this.mTransforms = transforms;
    }

    PerlTransformation(String transformFile, String inFile, String outFile) {
        super(inFile, outFile, transformFile);
        if (transformFile == null) {
            throw new NullPointerException();
        }
    }

    protected void doTransform(Reader input, Writer output, Reader source) throws IOException, CommandExecutionErrorException {
        Perl5Transform transform = null;
        if (source == null) {
            transform = new Perl5Transform();
            for (int i = 0; i < this.mTransforms.length; ++i) {
                transform.addSub(new Perl5Transform.Sub(this.mTransforms[i].getMatch(), this.mTransforms[i].getReplace()));
            }
        } else {
            transform = new Perl5Transform(new InputSource(source));
        }
        transform.apply(input, output);
    }
}

