/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.CommandUtil;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.command.commandresult.ExecNativeResult;
import com.raplix.rolloutexpress.command.commandresult.ProcessSpec;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.InvalidCommandException;
import com.raplix.rolloutexpress.command.exceptions.NativeCommandErrorException;
import com.raplix.rolloutexpress.command.impl.CommandImpl;
import com.raplix.rolloutexpress.command.impl.ExecNativeDescriptor;
import com.raplix.rolloutexpress.command.impl.SimpleExecNativeDescriptor;
import com.raplix.rolloutexpress.command.rpcinterfaces.NativePlatformIntegrationInterface;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.RegEx;
import java.util.Vector;

public abstract class NativePlatformIntegrationImpl
extends CommandImpl
implements NativePlatformIntegrationInterface,
CommandMessages {
    protected static boolean sRebootPending = false;
    protected Runtime mRuntime = Runtime.getRuntime();
    protected NativePlatformIntegration mNativeSubsystem;
    protected int mDefaultNativeTimeout;
    protected static final int MILLIS_SEC = 1000;

    protected NativePlatformIntegrationImpl(Application inApp, NativePlatformIntegration inNativeSubsystem) throws UnsupportedSubsystemException {
        super(inApp);
        this.mNativeSubsystem = inNativeSubsystem;
        try {
            this.mDefaultNativeTimeout = this.mNativeSubsystem.getConfigDefaultNativeTimeoutSecs();
        }
        catch (ConfigurationException ex) {
            throw new UnsupportedSubsystemException(ex);
        }
    }

    public ProcessSpec[] listProcesses() throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        return this.listProcesses(null);
    }

    public ExecNativeResult execNative(String inCommand) throws CommandExecutionErrorException, InvalidCommandException, RPCException {
        SimpleExecNativeDescriptor send = new SimpleExecNativeDescriptor(inCommand, this.mDefaultNativeTimeout);
        return (ExecNativeResult)this.execNative(send);
    }

    public RPCSerializable execNative(ExecNativeDescriptor inDescriptor) throws CommandExecutionErrorException, InvalidCommandException, RPCException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing command: " + inDescriptor.getCommandStringForErrMsg(), this);
        }
        inDescriptor.executeProcess(this.mNativeSubsystem);
        return inDescriptor.getResult();
    }

    public ExecNativeOutput getExecOutput(TaskID inTaskID, StepID inStepID) throws CommandExecutionErrorException, RPCException {
        return this.mNativeSubsystem.getOGStepManager().getCurrentOutput(inTaskID, inStepID);
    }

    public boolean checkProcess(String inProcName, String inUserName, int inDelaySecs, int inTimeoutSecs) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        int attempt;
        int nTries = inTimeoutSecs / inDelaySecs;
        if (nTries == 0) {
            nTries = 1;
        }
        boolean success = false;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("checkProcess for: " + inProcName + "[" + inUserName + "] with " + inDelaySecs + "/" + inTimeoutSecs + " and attempts: " + nTries, this);
        }
        RegEx userRE = CommandUtil.createRegEx(inUserName);
        RegEx procRE = CommandUtil.createRegEx(inProcName);
        for (attempt = 0; attempt < nTries && !success; ++attempt) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("checkProcess for: " + inProcName + "[" + inUserName + "] attempt: " + attempt, this);
            }
            success = this.checkProcessHelper(procRE, userRE, inUserName);
            try {
                Thread.sleep(inDelaySecs * 1000);
                continue;
            }
            catch (InterruptedException ex) {
                if (!Logger.isDebugEnabled(this)) break;
                Logger.debug("Interrupted while waiting in checkProcess", this);
                break;
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("checkProcess finished after " + attempt + " attempts with success: " + success, this);
        }
        return success;
    }

    public boolean isRebootPending() throws RPCException {
        return sRebootPending;
    }

    protected abstract void doReboot() throws CommandExecutionErrorException;

    public void reboot() throws CommandExecutionErrorException {
        this.doReboot();
        sRebootPending = true;
    }

    private boolean checkProcessHelper(RegEx inProcRE, RegEx inUserRE, String inUserName) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        ProcessSpec[] procs = this.listProcesses(inUserName);
        Vector matches = ProcessSpec.getSpecForProcess(procs, inUserRE, inProcRE);
        return matches != null;
    }

    public Vector getMatchingRunningProcs(String cmdToMatch, String inUser) throws RPCException, CommandExecutionErrorException {
        RegEx userRE = CommandUtil.createRegEx(inUser);
        RegEx procRE = CommandUtil.createRegEx(cmdToMatch);
        ProcessSpec[] allSpecs = this.listProcesses(inUser);
        Vector matchingProcs = ProcessSpec.getSpecForProcess(allSpecs, userRE, procRE);
        return matchingProcs;
    }
}

