/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.commandresult.ExecNativeResult;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.InvalidUserGroupException;
import com.raplix.rolloutexpress.command.exceptions.RANoRootPrivilegesException;
import com.raplix.rolloutexpress.command.impl.DeployImplBase;
import com.raplix.rolloutexpress.command.impl.ResourcePermissionSetter;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.rolloutexpress.command.rpcinterfaces.MEMIXInterface;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ItemID;
import com.raplix.rolloutexpress.command.stickydata.Table;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.executor.ResourceEventData;
import com.raplix.rolloutexpress.executor.task.ExecNativeStepDescriptor;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceProcessException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.Host;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.aix.AixHost;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.memix.commands.SessionFactory;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.posix.PosixHost;
import com.raplix.util.memix.solaris.SolarisHost;
import com.raplix.util.memix.users.UserTableEntry;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Environ;
import com.raplix.util.platform.posix.Process;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class MEMIXImpl
extends DeployImplBase
implements MEMIXInterface,
CommandMessages {
    private static final String HOST_NAME = "agent";
    private boolean mKeep;
    private ItemID mLastID;
    private NotificationManager mNotificationMgr;
    private Table mStickyTable;

    public MEMIXImpl(Application app) throws UnsupportedSubsystemException {
        super(app);
        this.mNotificationMgr = app.getNotificationManager();
        this.mStickyTable = ((Agent)app).getStickySubsystem().getTable(PlanSubsystem.CLASS_SUBSYSTEM_ID);
    }

    private Simulator getSimulator(ItemID handle) throws CommandExecutionErrorException {
        try {
            return (Simulator)this.mStickyTable.getItem(handle);
        }
        catch (IllegalArgumentException ex) {
            throw new CommandExecutionErrorException("cmd.ERR_MEMIX_HANDLE", handle);
        }
    }

    private ExecNativeResult execNative(Simulator s, String inCommand) throws CommandExecutionErrorException, RPCException {
        s.mSessionStrOut.getBuffer().setLength(0);
        s.mSessionStrErr.getBuffer().setLength(0);
        try {
            s.mSession.exec(inCommand);
        }
        catch (Exception ex) {
            throw new CommandExecutionErrorException("cmd.ERR_EXEC_NATIVE", (Throwable)ex, new Object[]{ex.getMessage(), inCommand});
        }
        s.mSessionPrOut.flush();
        s.mSessionPrErr.flush();
        return new ExecNativeResult(0, s.mSessionStrOut.toString(), s.mSessionStrErr.toString());
    }

    private String memixify(String inString) {
        int theIdx = inString.indexOf(":");
        String theTruncString = inString.substring(theIdx + 1, inString.length());
        return theTruncString.replace('\\', '/');
    }

    public ItemID createSimulator(BagID bagID) throws CommandExecutionErrorException, RPCException {
        Simulator s = new Simulator();
        s.mHost = PlatformUtil.isSolaris() ? new SolarisHost(HOST_NAME, "/") : (PlatformUtil.isAix() ? new AixHost(HOST_NAME, "/") : (PlatformUtil.isPOSIX() ? new PosixHost(HOST_NAME, File.separator, File.separator) : new Host(HOST_NAME)));
        try {
            s.mSession = s.mHost.getRootSession();
            if (PlatformUtil.isPOSIX()) {
                UserTableEntry entry = s.mHost.getUsers().getEntry(((PosixHost)s.mHost).getUserID(Process.getUID()));
                s.mSession = (SessionCommand)s.mSession.exec(SessionFactory.FILE_ID.toString())[0];
                s.mSession.exec("su " + entry.getName());
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionErrorException("cmd.ERR_MEMIX_CREATE", (Throwable)ex, ex.getMessage());
        }
        s.mSessionStrOut = new StringWriter();
        s.mSessionPrOut = new PrintWriter(s.mSessionStrOut);
        s.mSessionStrErr = new StringWriter();
        s.mSessionPrErr = new PrintWriter(s.mSessionStrErr);
        s.mSession.getProcessEntry().setStdout(s.mSession, s.mSessionPrOut);
        s.mSession.getProcessEntry().setStderr(s.mSession, s.mSessionPrErr);
        this.mLastID = this.mStickyTable.addItem(s, bagID, null);
        return this.mLastID;
    }

    public void deleteSimulator(ItemID handle) throws RPCException {
        if (this.mKeep) {
            return;
        }
        this.mStickyTable.removeItem(handle);
    }

    public ExecNativeResult execNative(ItemID handle, String inCommand) throws CommandExecutionErrorException, RPCException {
        return this.execNative(this.getSimulator(handle), inCommand);
    }

    public void execNative(ItemID handle, ExecNativeStepDescriptor stepDescriptor) throws CommandExecutionErrorException, RPCException {
        SessionCommand agentSession = null;
        SessionCommand commandSession = null;
        Simulator s = this.getSimulator(handle);
        try {
            agentSession = s.mSession;
            if (stepDescriptor.getUserToRunAs() == null) {
                commandSession = s.mSession;
            } else {
                commandSession = (SessionCommand)s.mHost.getRootSession().exec(SessionFactory.FILE_ID.toString())[0];
                commandSession.exec("su " + stepDescriptor.getUserToRunAs());
            }
            this.simulateExecNative(stepDescriptor, commandSession, agentSession);
        }
        catch (Exception ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error simulating execNative", ex, this);
            }
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ENATIVE_ERR_SIMULATE", stepDescriptor.getCommandStringForErrMsg()), (Throwable)ex);
        }
    }

    public void uninstallDeployedFiles(ItemID handle, String[][] inPaths) throws CommandExecutionErrorException, RPCException {
        this.deleteFiles(handle, MEMIXImpl.resolvePathPairs(inPaths));
    }

    public void deleteFiles(ItemID handle, String[] inPaths) throws CommandExecutionErrorException, RPCException {
        for (int i = 0; i < inPaths.length; ++i) {
            String local = FileSpec.convertPathSeparatorToLocal(inPaths[i]);
            this.execNative(handle, "rm -R " + local);
        }
    }

    private void simulateExecNative(ExecNativeStepDescriptor descriptor, SessionCommand userSession, SessionCommand agentSession) throws UnsupportedSubsystemException, ConfigurationException, CommandExecutionErrorException {
        File dir = null;
        descriptor.preflightInit(this.getApplication().getNativeSubsystem());
        dir = descriptor.getExecutionDir();
        if (!dir.isAbsolute()) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ENATIVE_WDIR_NOT_ABSOLUTE", dir.toString(), descriptor.getCommandStringForErrMsg()));
        }
        MEMIXImpl.checkDirectoryExecutePerm(userSession, dir);
        File file = descriptor.getFileForReadPermCheck();
        if (file != null) {
            MEMIXImpl.checkReadPerm(agentSession, file);
        }
        File[] files = descriptor.getFilesForWritePermCheck();
        for (int i = 0; i < files.length; ++i) {
            MEMIXImpl.checkWritePerm(agentSession, files[i]);
        }
        MEMIXImpl.checkCmdExecutable(userSession, descriptor.getCommandNameForPermCheck());
    }

    public void transformFile(ItemID handle, Transformation inTransformation, String[] archiveSuffix) throws CommandExecutionErrorException, RPCException {
        File file = null;
        SessionCommand s = this.getSimulator((ItemID)handle).mSession;
        file = inTransformation.getInputFile();
        if (file != null) {
            MEMIXImpl.checkReadPerm(s, file, archiveSuffix);
        }
        if ((file = inTransformation.getSourceFile()) != null) {
            MEMIXImpl.checkReadPerm(s, file);
        }
        if ((file = inTransformation.getOutputFile()) != null) {
            MEMIXImpl.checkWritePerm(s, file, archiveSuffix);
        }
    }

    public void installDeployedResources(ItemID handle, ResourceEventData inEventData, ResourceDefinition[] inAllRsrcDefns, InstalledResource[] inInstalledResources, PushID inPushID) throws CommandExecutionErrorException, RPCException {
        Simulator s = this.getSimulator(handle);
        int nRsrcToInstall = inAllRsrcDefns.length;
        if (nRsrcToInstall != inInstalledResources.length) {
            throw new CommandExecutionErrorException("cmd.ERR_RSRC_INSTALL_WRONG_NUMBER_ARGS", new Object[]{new Integer(inAllRsrcDefns.length), new Integer(inInstalledResources.length)});
        }
        for (int i = 0; i < nRsrcToInstall; ++i) {
            this.installOneResource(inEventData, s, inAllRsrcDefns[i], inInstalledResources[i], inPushID);
        }
    }

    protected void externalize(ResourceID inResourceID, PushID inPushID, DeployMode inDeployMode, AbsoluteFileSpec inDst, NodePerms inOverridePerms, DeployImplBase.DeploySimulator inSim) throws ResourceException, RPCException {
        Simulator sim = (Simulator)inSim;
        this.mRsrcMgr.externalizeToMemix(inResourceID, inPushID, inDeployMode, inDst, sim.mSession, inOverridePerms);
    }

    protected ResourcePermissionSetter getResourcePermissionSetter(ResourceEventData inRED, DeployImplBase.DeploySimulator inSim, String inUser, String inGroup, int inPerms) throws InvalidUserGroupException, RANoRootPrivilegesException {
        return new MEMIXPermissionSetter(inUser, inGroup, inPerms, inRED.getDefaultParentDirUser(), inRED.getDefaultParentDirGroup(), (Simulator)inSim);
    }

    public void keepSimulators() throws RPCException {
        this.mKeep = true;
    }

    public ItemID getLastHandle() {
        return this.mLastID;
    }

    private static void checkWritePerm(SessionCommand s, File file) throws CommandExecutionErrorException {
        MEMIXImpl.checkWritePerm(s, file, null);
    }

    private static void checkWritePerm(SessionCommand s, File file, String[] archiveSuffix) throws CommandExecutionErrorException {
        try {
            FileNode tmp = s.getHost().getFileSystem().getFileNode(s, new FID(file.getPath()));
            if (!tmp.canWrite(s)) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_WRITABLE", new String[]{MEMIXImpl.getUserName(s), file.toString()}));
            }
            return;
        }
        catch (IllegalArgumentException ignored) {
            try {
                DirectoryNode dirNode = s.getHost().getFileSystem().getDirectoryNode(s, new FID(file.getParent()));
                if (!dirNode.canExecute(s)) {
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_PARENT_DIR_NOT_EXECUTABLE", new String[]{MEMIXImpl.getUserName(s), file.toString()}));
                }
                if (!dirNode.canWrite(s)) {
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_PARENT_DIR_NOT_WRITABLE", new String[]{MEMIXImpl.getUserName(s), file.toString()}));
                }
            }
            catch (IllegalArgumentException e) {
                String archivePath;
                if (archiveSuffix != null && (archivePath = MEMIXImpl.getArchivePathFromGeneralizedPath(file.getPath(), archiveSuffix)) != null) {
                    File aFile = new File(archivePath);
                    MEMIXImpl.checkReadPerm(s, aFile);
                    MEMIXImpl.checkWritePerm(s, aFile);
                    return;
                }
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_FOUND", new String[]{file.toString()}));
            }
            return;
        }
    }

    private static void checkReadPerm(SessionCommand s, File file) throws CommandExecutionErrorException {
        MEMIXImpl.checkReadPerm(s, file, null);
    }

    private static void checkReadPerm(SessionCommand s, File file, String[] archiveSuffix) throws CommandExecutionErrorException {
        try {
            FileNode tmp = s.getHost().getFileSystem().getFileNode(s, new FID(file.getPath()));
            if (!tmp.canRead(s)) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_READABLE", new String[]{MEMIXImpl.getUserName(s), file.toString()}));
            }
        }
        catch (IllegalArgumentException e) {
            String archivePath;
            if (archiveSuffix != null && (archivePath = MEMIXImpl.getArchivePathFromGeneralizedPath(file.getPath(), archiveSuffix)) != null) {
                MEMIXImpl.checkReadPerm(s, new File(archivePath));
                return;
            }
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_FOUND", new String[]{file.toString()}));
        }
    }

    private static void checkDirectoryExecutePerm(SessionCommand c, File dir) throws CommandExecutionErrorException {
        try {
            DirectoryNode tmp = c.getHost().getFileSystem().getDirectoryNode(c, new FID(dir.getPath()));
            if (!tmp.canExecute(c)) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.MSG_DIR_NOT_EXECUTABLE", MEMIXImpl.getUserName(c), dir.toString()));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.MSG_DIR_NOT_FOUND", new String[]{dir.toString()}), (Throwable)iae);
        }
    }

    private static String getArchivePathFromGeneralizedPath(String path, String[] archiveSuffix) {
        String archivePath = null;
        int idx = 0;
        for (int i = 0; i < archiveSuffix.length; ++i) {
            idx = path.indexOf(archiveSuffix[i] + File.separator);
            if (idx < 0) continue;
            archivePath = path.substring(0, idx) + archiveSuffix[i];
            break;
        }
        return archivePath;
    }

    private static void checkNodeReadPerm(SessionCommand s, File file) throws CommandExecutionErrorException {
        try {
            Node tmp = s.getHost().getFileSystem().getNode((ProcessContext)s, new FID(file.getPath()), true);
            if (!tmp.canRead(s)) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_READABLE", new String[]{MEMIXImpl.getUserName(s), file.toString()}));
            }
        }
        catch (IllegalArgumentException e) {
            throw new CommandExecutionErrorException(new ROXMessage("cmd.ERR_FILE_NOT_FOUND", new String[]{file.toString()}));
        }
    }

    private static void checkCmdExecutable(SessionCommand s, String cmdToExec) throws CommandExecutionErrorException {
        block10: {
            File cmd = new File(cmdToExec);
            FileNode tmp = null;
            if (cmd.isAbsolute()) {
                try {
                    tmp = s.getHost().getFileSystem().getFileNode(s, new FID(cmdToExec));
                    if (!tmp.canExecute(s)) {
                        throw new CommandExecutionErrorException(new ROXMessage("cmd.MSG_CMD_NOT_EXECUTABLE", MEMIXImpl.getUserName(s), cmdToExec));
                    }
                    break block10;
                }
                catch (IllegalArgumentException e) {
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.MSG_CMD_NOT_FOUND", cmdToExec));
                }
            }
            String path = Environ.getValue("PATH");
            if (path != null && path.trim().length() > 0) {
                String[] pathComponents = Util.splitString(path, File.pathSeparator);
                for (int i = 0; i < pathComponents.length; ++i) {
                    try {
                        tmp = s.getHost().getFileSystem().getFileNode(s, new FID(pathComponents[i]).append(cmdToExec));
                        continue;
                    }
                    catch (IllegalArgumentException ignored) {
                        // empty catch block
                    }
                }
                if (tmp == null) {
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.MSG_CMD_NOT_FOUND", cmdToExec));
                }
                if (!tmp.canExecute(s)) {
                    throw new CommandExecutionErrorException(new ROXMessage("cmd.MSG_CMD_NOT_EXECUTABLE", MEMIXImpl.getUserName(s), cmdToExec));
                }
            }
        }
    }

    private static String getUserName(SessionCommand s) {
        String uname = "";
        try {
            uname = s.getHost().getUsers().getEntry(s.getUserID()).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uname;
    }

    private class MEMIXPermissionSetter
    extends ResourcePermissionSetter {
        private Simulator mSim;

        protected MEMIXPermissionSetter(String inInstallUser, String inInstallGroup, int inOctet, String inDefaultParentUser, String inDefaultParentGroup, Simulator inSim) throws InvalidUserGroupException, RANoRootPrivilegesException {
            super(inInstallUser, inInstallGroup, inOctet, inDefaultParentUser, inDefaultParentGroup);
            this.mSim = inSim;
        }

        protected String preparePath(String inString) {
            return MEMIXImpl.this.memixify(inString);
        }

        protected void performChownChgrp(String inPath, String inInstallUser, String inInstallGroup) throws ResourceProcessException {
            try {
                if (inInstallUser != null) {
                    MEMIXImpl.this.execNative(this.mSim, "chown -R " + inInstallUser + " " + inPath);
                }
                if (inInstallGroup != null) {
                    MEMIXImpl.this.execNative(this.mSim, "chgrp -R " + inInstallGroup + " " + inPath);
                }
            }
            catch (RaplixException ex) {
                throw new ResourceProcessException(ex);
            }
        }
    }

    private static class Simulator
    implements DeployImplBase.DeploySimulator {
        public Host mHost;
        public SessionCommand mSession;
        public StringWriter mSessionStrOut;
        public PrintWriter mSessionPrOut;
        public StringWriter mSessionStrErr;
        public PrintWriter mSessionPrErr;

        private Simulator() {
        }
    }
}

