/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import [Lcom.raplix.rolloutexpress.command.commandresult.FileSpec;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.commandresult.DirectorySpec;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.commandresult.SymlinkSpec;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.InvalidUserGroupException;
import com.raplix.rolloutexpress.command.exceptions.NativeCommandErrorException;
import com.raplix.rolloutexpress.command.exceptions.PathDoesNotExistException;
import com.raplix.rolloutexpress.command.exceptions.RANoRootPrivilegesException;
import com.raplix.rolloutexpress.command.impl.DeployImplBase;
import com.raplix.rolloutexpress.command.impl.ResourcePermissionSetter;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.rolloutexpress.command.rpcinterfaces.FileOperationsInterface;
import com.raplix.rolloutexpress.executor.ResourceEventData;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.FileInfo;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.Link;
import com.raplix.util.platform.posix.Stat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Vector;

public class FileOperationsImpl
extends DeployImplBase
implements FileOperationsInterface {
    private static final int COPY = 100;
    private static final int MOVE = 101;
    private static final int RENAME = 102;

    public FileOperationsImpl(Application inApp) throws UnsupportedSubsystemException {
        super(inApp);
    }

    public void moveFile(String inSrcPath, String inDestPath) throws CommandExecutionErrorException, RPCException {
        this.doTwoFileIOOperation(inSrcPath, "source path", inDestPath, "destination path", 101, "move");
    }

    public void renameFile(String inBeforeName, String inAfterName) throws CommandExecutionErrorException, RPCException {
        this.doTwoFileIOOperation(inBeforeName, "original name", inAfterName, "destination name", 102, "rename");
    }

    public void copyFile(String inSrcPath, String inDestPath) throws CommandExecutionErrorException, RPCException {
        this.doTwoFileIOOperation(inSrcPath, "source path", inDestPath, "destination path", 100, "copy");
    }

    public void uninstallDeployedFiles(String[][] inPaths) throws CommandExecutionErrorException {
        this.deleteFiles(FileOperationsImpl.resolvePathPairs(inPaths));
    }

    public void deleteFiles(String[] inPaths) throws CommandExecutionErrorException {
        for (int i = 0; i < inPaths.length; ++i) {
            String thePath = FileSpec.convertPathSeparatorToLocal(inPaths[i]);
            File file = new File(thePath);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("deleting file: " + file.getAbsolutePath(), this);
            }
            try {
                ResourceFileUtils.deleteDirectory(file);
                continue;
            }
            catch (ResourceException e) {
                throw new CommandExecutionErrorException("cmd.ERR_DELETE_PATH", thePath);
            }
        }
    }

    public FileSpec getFileInfo(boolean followLinks, String inAbsPath) throws NativeCommandErrorException, CommandExecutionErrorException, PathDoesNotExistException, RPCException {
        if (inAbsPath == null) {
            throw new CommandExecutionErrorException("cmd.INVALID_INCOMING_PATH_NULL");
        }
        inAbsPath = FileSpec.convertPathSeparatorToLocal(inAbsPath);
        RoxAddress address = this.mApplication.getLocalNodeAddress();
        File file = new File(inAbsPath);
        if (!followLinks) {
            FileInfo info = new FileInfo(file);
            if (info.isLink()) {
                try {
                    return new SymlinkSpec(address, inAbsPath, new Stat(inAbsPath).getSize(), Link.read(inAbsPath));
                }
                catch (IllegalArgumentException ex) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Cannot read link: " + inAbsPath, ex, this);
                    }
                    throw new PathDoesNotExistException("cmd.ERR_GET_INFO_PATH_DNE", inAbsPath);
                }
            }
            if (info.isDirectory()) {
                return new DirectorySpec(address, inAbsPath, file.list());
            }
            if (info.isPlain()) {
                return new FileSpec(address, inAbsPath, file.length());
            }
        } else if (file.exists()) {
            if (file.isDirectory()) {
                return new DirectorySpec(address, inAbsPath, file.list());
            }
            if (file.isFile()) {
                return new FileSpec(address, inAbsPath, file.length());
            }
        }
        if (Logger.isErrorEnabled(this)) {
            Logger.error("Cannot process file: " + inAbsPath, this);
        }
        throw new PathDoesNotExistException("cmd.ERR_GET_INFO_PATH_DNE", inAbsPath);
    }

    public void installDeployedResources(ResourceEventData inEventData, ResourceDefinition[] inAllRsrcDefns, InstalledResource[] inInstalledResources, PushID inPushID) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        int nRsrcToInstall = inAllRsrcDefns.length;
        if (nRsrcToInstall != inInstalledResources.length) {
            throw new CommandExecutionErrorException("cmd.ERR_RSRC_INSTALL_WRONG_NUMBER_ARGS", new Object[]{new Integer(inAllRsrcDefns.length), new Integer(inInstalledResources.length)});
        }
        for (int i = 0; i < nRsrcToInstall; ++i) {
            this.installOneResource(inEventData, null, inAllRsrcDefns[i], inInstalledResources[i], inPushID);
        }
    }

    public FileSpec[] getDirFilesInfo(boolean followLinks, String inAbsPath) throws NativeCommandErrorException, CommandExecutionErrorException, RPCException {
        String[] files;
        if (inAbsPath == null) {
            throw new CommandExecutionErrorException("cmd.INVALID_INCOMING_PATH_NULL");
        }
        FileSpec f = this.getFileInfo(followLinks, inAbsPath = FileSpec.convertPathSeparatorToLocal(inAbsPath));
        if (!(f instanceof DirectorySpec)) {
            return new FileSpec[]{f};
        }
        try {
            files = ((DirectorySpec)f).getContents();
            if (files == null) {
                return new FileSpec[0];
            }
        }
        catch (Exception ex) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Error reading directory contents.", ex, this);
            }
            return new FileSpec[0];
        }
        Vector<FileSpec> resultVec = new Vector<FileSpec>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..")) continue;
            try {
                resultVec.addElement(this.getFileInfo(followLinks, inAbsPath + File.separatorChar + files[i]));
                continue;
            }
            catch (Exception ex) {
                if (!Logger.isDebugEnabled(this)) continue;
                Logger.debug("Error reading file " + files[i], ex, this);
            }
        }
        return (FileSpec[])CollectionUtil.mapClass(resultVec, FileSpec;.class);
    }

    public boolean doesFileExist(String inAbsPath) throws RPCException {
        inAbsPath = FileSpec.convertPathSeparatorToLocal(inAbsPath);
        return this.checkFileExistsAndIsFile(new File(inAbsPath));
    }

    private void doTwoFileIOOperation(String inSrc, String inSrcLabel, String inDest, String inDestLabel, int inAction, String inActionLabel) throws CommandExecutionErrorException {
        if (inSrc == null) {
            throw new CommandExecutionErrorException("cmd.ERR_2FILEIO_NULL_ARG", inSrcLabel);
        }
        File srcFile = new File(inSrc = FileSpec.convertPathSeparatorToLocal(inSrc));
        if (!srcFile.exists()) {
            throw new CommandExecutionErrorException("cmd.ERR_2FILEIO_ARG_DNE", new Object[]{inSrcLabel, inSrc});
        }
        if (inDest == null) {
            throw new CommandExecutionErrorException("cmd.ERR_2FILEIO_DEST_ARG_NULL", new Object[]{inDestLabel, inDest});
        }
        inDest = FileSpec.convertPathSeparatorToLocal(inDest);
        File destFile = new File(inDest);
        boolean fSuccess = false;
        try {
            switch (inAction) {
                case 101: 
                case 102: {
                    fSuccess = srcFile.renameTo(destFile);
                    break;
                }
                case 100: {
                    this.doCopy(srcFile, destFile);
                    fSuccess = true;
                }
            }
        }
        catch (SecurityException sex) {
            throw new CommandExecutionErrorException("cmd.ERR_2FILEIO_FAILED", (Throwable)sex, new Object[]{inActionLabel, inSrc, inDest});
        }
        catch (IOException ex) {
            throw new CommandExecutionErrorException("cmd.ERR_2FILEIO_FAILED", (Throwable)ex, new Object[]{inActionLabel, inSrc, inDest});
        }
        if (!fSuccess) {
            throw new CommandExecutionErrorException("cmd.ERR_2FILEIO_FAILED", new Object[]{inActionLabel, inSrc, inDest});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doCopy(File src, File dest) throws IOException, SecurityException, CommandExecutionErrorException {
        FilterOutputStream ostream;
        block8: {
            BufferedInputStream istream = null;
            ostream = null;
            try {
                try {
                    if (!this.checkFileExistsAndIsFile(src)) {
                        throw new CommandExecutionErrorException("cmd.ERR_DO_COPY", src);
                    }
                    istream = new BufferedInputStream(new FileInputStream(src));
                    ostream = new BufferedOutputStream(new FileOutputStream(dest));
                    Util.copyStream(istream, ostream);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (SecurityException sex) {
                    throw sex;
                }
                Object var7_5 = null;
                if (istream == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (istream != null) {
                    istream.close();
                }
                if (ostream == null) throw throwable;
                ostream.close();
                throw throwable;
            }
            istream.close();
        }
        if (ostream == null) return;
        ostream.close();
    }

    private boolean checkFileExistsAndIsFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    protected void externalize(ResourceID inResourceID, PushID inPushID, DeployMode inDeployMode, AbsoluteFileSpec inDst, NodePerms inOverridePerms, DeployImplBase.DeploySimulator inSim) throws ResourceException, RPCException {
        this.mRsrcMgr.externalize(inResourceID, inPushID, inDeployMode, inDst, inOverridePerms);
    }

    protected ResourcePermissionSetter getResourcePermissionSetter(ResourceEventData inRED, DeployImplBase.DeploySimulator inSim, String inUser, String inGroup, int inPerms) throws InvalidUserGroupException, RANoRootPrivilegesException, NativeCommandErrorException {
        return new ResourcePermissionSetter(inUser, inGroup, inPerms, inRED.getDefaultParentDirUser(), inRED.getDefaultParentDirGroup());
    }

    public void transformFile(Transformation inTransformation) throws RPCException, CommandExecutionErrorException {
        inTransformation.transformFile();
    }

    public String getLinkTarget(String inFullPath) throws RPCException {
        return ResourceFileUtils.getLinkTarget(new File(inFullPath));
    }

    public String createTempFile(String prefix, String suffix) throws CommandExecutionErrorException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new CommandExecutionErrorException("cmd.MSG_CANNOT_CREATE_TEMP_FILE", (Throwable)e);
        }
        return tempFile.getAbsolutePath();
    }
}

