/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.command.CommandMessages;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.InvalidCommandException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.executor.Exec;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ExecNativeDescriptor
implements RPCSerializable,
CommandMessages {
    private boolean mIsTimedOut = false;
    private long mExitStatus = Long.MAX_VALUE;
    private long mTimeoutSecs = -1L;
    public static final long EXIT_STATUS_NOT_AVAILABLE = Long.MAX_VALUE;
    public static final long STREAM_TIMEOUT = -3L;

    protected ExecNativeDescriptor(long timeout) {
        this.mTimeoutSecs = timeout;
    }

    protected ExecNativeDescriptor() {
    }

    public long getTimeoutSecs() {
        return this.mTimeoutSecs;
    }

    public boolean isTimedOut() {
        return this.mIsTimedOut;
    }

    protected void setTimeoutSecs(long timeout) {
        this.mTimeoutSecs = timeout;
    }

    public long getExitStatus() {
        return this.mExitStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void executeProcess(NativePlatformIntegration inSubsystem) throws CommandExecutionErrorException, InvalidCommandException {
        try {
            Process process;
            OutputStream error;
            OutputStream output;
            InputStream input;
            block26: {
                IOException ioe22;
                block27: {
                    this.init(inSubsystem);
                    input = null;
                    output = null;
                    error = null;
                    process = null;
                    boolean processStarted = false;
                    try {
                        input = this.getInput();
                        output = this.getOutput();
                        error = this.getError();
                        process = this.createProcess();
                        processStarted = true;
                        Object var8_8 = null;
                        if (processStarted) break block26;
                        if (input == null) break block27;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (!processStarted) {
                            IOException ioe22;
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException ioe22) {
                                    // empty catch block
                                }
                            }
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (IOException ioe22) {
                                    // empty catch block
                                }
                            }
                            if (error != null) {
                                try {
                                    error.close();
                                }
                                catch (IOException ioe22) {
                                    // empty catch block
                                }
                            }
                        }
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (error != null) {
                    try {
                        error.close();
                    }
                    catch (IOException ioe22) {}
                }
            }
            Exec nativeRunner = new Exec(process, input, output, error, this.getTimeoutSecs() * 1000L, -3L);
            this.mIsTimedOut = nativeRunner.isTimedOut();
            if (!this.mIsTimedOut) {
                this.mExitStatus = nativeRunner.getExitCode();
                this.postProcess();
            } else {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("native process timed out while executing", this);
                }
                CommandExecutionErrorException timeoutError = nativeRunner.getExecutionThread().isTimedOut() ? new CommandExecutionErrorException("cmd.ERR_EXEC_NATIVE_CMD_TIMEOUT", this.getCommandStringForErrMsg()) : new CommandExecutionErrorException("cmd.ERR_EXEC_NATIVE_STREAM_TIMEOUT", this.getCommandStringForErrMsg());
                this.timedOut(timeoutError);
            }
        }
        catch (InterruptedException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ex.getMessage(), this);
            }
            throw new CommandExecutionErrorException("cmd.ERR_EXEC_NATIVE", (Throwable)ex, new Object[]{ex.getMessage(), this.getCommandStringForErrMsg()});
        }
        finally {
            this.cleanUp();
        }
    }

    protected void timedOut(CommandExecutionErrorException timeoutError) throws CommandExecutionErrorException {
        throw timeoutError;
    }

    protected abstract InputStream getInput() throws CommandExecutionErrorException;

    protected abstract OutputStream getOutput() throws CommandExecutionErrorException;

    protected abstract OutputStream getError() throws CommandExecutionErrorException;

    protected abstract String getCommandStringForErrMsg();

    protected abstract void postProcess() throws CommandExecutionErrorException;

    protected abstract Process createProcess() throws CommandExecutionErrorException;

    protected void init(NativePlatformIntegration inSubsystem) throws CommandExecutionErrorException {
    }

    protected void cleanUp() throws CommandExecutionErrorException {
    }

    protected RPCSerializable getResult() {
        return null;
    }
}

