/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.impl;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.InvalidUserGroupException;
import com.raplix.rolloutexpress.command.exceptions.NativeCommandErrorException;
import com.raplix.rolloutexpress.command.exceptions.RANoRootPrivilegesException;
import com.raplix.rolloutexpress.command.impl.CommandImpl;
import com.raplix.rolloutexpress.command.impl.ResourcePermissionSetter;
import com.raplix.rolloutexpress.executor.ResourceEventData;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.File;

public abstract class DeployImplBase
extends CommandImpl {
    protected ResourceSubsystem mRsrcMgr;

    public DeployImplBase(Application inApp) throws UnsupportedSubsystemException {
        super(inApp);
        this.mRsrcMgr = inApp.getResourceSubsystem();
    }

    protected abstract void externalize(ResourceID var1, PushID var2, DeployMode var3, AbsoluteFileSpec var4, NodePerms var5, DeploySimulator var6) throws ResourceException, RPCException;

    protected abstract ResourcePermissionSetter getResourcePermissionSetter(ResourceEventData var1, DeploySimulator var2, String var3, String var4, int var5) throws InvalidUserGroupException, RANoRootPrivilegesException, NativeCommandErrorException;

    protected final void installOneResource(ResourceEventData inRED, DeploySimulator inSim, ResourceDefinition inRsrcDefn, InstalledResource inResource, PushID inPushID) throws CommandExecutionErrorException, RPCException {
        String destPath = FileSpec.convertPathSeparatorToLocal(inResource.getInstallPath());
        File theFile = new File(destPath);
        String parentPath = theFile.getParent();
        if (parentPath == null) {
            throw new CommandExecutionErrorException("cmd.ERR_INSTALL_PARENT_PATH_NULL", new Object[]{inRsrcDefn.getInstallName(), destPath});
        }
        try {
            this.performInstallToDisk(inRED, inRsrcDefn, inResource, inPushID, destPath, inSim);
        }
        catch (ResourceException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error: ", ex, this);
            }
            throw new CommandExecutionErrorException("cmd.ERR_INSTALL_RSRC", (Throwable)ex);
        }
    }

    public static final String[] resolvePathPairs(String[][] inPathPairs) {
        String[] generated = new String[inPathPairs.length];
        for (int i = 0; i < generated.length; ++i) {
            generated[i] = new File(inPathPairs[i][0], inPathPairs[i][1]).getPath();
        }
        return generated;
    }

    private void performInstallToDisk(ResourceEventData inRED, ResourceDefinition inRsrcDefn, InstalledResource inResource, PushID inPushID, String inDestPath, DeploySimulator inSim) throws ResourceException, CommandExecutionErrorException {
        this.createResourceInstaller(inRED, inRsrcDefn, new AbsoluteFileSpec(inDestPath), inResource, inPushID, inSim).access();
    }

    private ResourceAccessor createResourceInstaller(ResourceEventData inRED, ResourceDefinition inRsrcDefn, AbsoluteFileSpec inDestSpec, InstalledResource inResource, PushID inPushID, DeploySimulator inSim) throws ResourceException, CommandExecutionErrorException {
        return PlatformUtil.isPOSIX() ? new PosixResourceInstaller(inRED, inRsrcDefn, inDestSpec, inResource, inPushID, inSim) : new WindowsResourceInstaller(inRsrcDefn, inDestSpec, inResource, inPushID, inSim);
    }

    private class WindowsResourceInstaller
    extends ResourceAccessor {
        private ResourceDefinition mRsrcDefn;
        private AbsoluteFileSpec mDestSpec;
        private InstalledResource mResource;
        private PushID mPushID;
        private DeploySimulator mSim;

        WindowsResourceInstaller(ResourceDefinition inRsrcDefn, AbsoluteFileSpec inDestSpec, InstalledResource inResource, PushID inPushID, DeploySimulator inSim) {
            super(DeployImplBase.this.mRsrcMgr);
            this.mRsrcDefn = inRsrcDefn;
            this.mDestSpec = inDestSpec;
            this.mResource = inResource;
            this.mPushID = inPushID;
            this.mSim = inSim;
        }

        public Object innerAccess() throws ResourceException {
            NodePerms thePerms = DeployImplBase.this.mRsrcMgr.createDefaultNodePerms();
            try {
                DeployImplBase.this.externalize(this.mResource.getResourceID(), this.mPushID, this.mRsrcDefn.getDeployMode(), this.mDestSpec, thePerms, this.mSim);
            }
            catch (RPCException ex) {
                throw new ResourceException(ex);
            }
            return null;
        }
    }

    private class PosixResourceInstaller
    extends ResourceAccessor {
        private ResourcePermissionSetter mSetter;
        private ResourceDefinition mRsrcDefn;
        private AbsoluteFileSpec mDestSpec;
        private InstalledResource mResource;
        private PushID mPushID;
        private DeploySimulator mSim;

        PosixResourceInstaller(ResourceEventData inRED, ResourceDefinition inRsrcDefn, AbsoluteFileSpec inDestSpec, InstalledResource inResource, PushID inPushID, DeploySimulator inSim) throws ResourceException, CommandExecutionErrorException {
            super(DeployImplBase.this.mRsrcMgr);
            this.mRsrcDefn = inRsrcDefn;
            this.mDestSpec = inDestSpec;
            this.mResource = inResource;
            this.mPushID = inPushID;
            this.mSim = inSim;
            this.mSetter = DeployImplBase.this.getResourcePermissionSetter(inRED, inSim, inRsrcDefn.getInstallUser(), inRsrcDefn.getInstallGroup(), inRsrcDefn.getInstallPermissionsAsOctalInt());
            DeployImplBase.this.mRsrcMgr.getRsrcPush(inPushID).addProcess(this.mSetter, inResource.getResourceID());
        }

        public Object innerAccess() throws ResourceException {
            PosixNodePerms thePerms = (PosixNodePerms)DeployImplBase.this.mRsrcMgr.createDefaultNodePerms();
            ResourceID resourceID = this.mResource.getResourceID();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Changing owner of " + resourceID + " to " + this.mSetter.getInstallUser(), this);
            }
            thePerms.setOwnerName(this.mSetter.getInstallUser());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Changing group of " + resourceID + " to " + this.mSetter.getInstallGroup(), this);
            }
            thePerms.setGroupName(this.mSetter.getInstallGroup());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Changing permissions of " + resourceID + " to " + this.mSetter.getInstallPermissions(), this);
            }
            thePerms.setPermBits(this.mSetter.getInstallPermissions());
            try {
                DeployImplBase.this.externalize(this.mResource.getResourceID(), this.mPushID, this.mRsrcDefn.getDeployMode(), this.mDestSpec, thePerms, this.mSim);
            }
            catch (RPCException ex) {
                throw new ResourceException(ex);
            }
            return null;
        }
    }

    protected static interface DeploySimulator {
    }
}

