/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.commandresult;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.RegEx;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProcessSpec
implements Serializable,
RPCSerializable {
    private static final String LOGGER_NAME = ProcessSpec.class.getName();
    protected String mUser;
    protected int mProcessID;
    protected String mCommand;

    private ProcessSpec() {
    }

    public ProcessSpec(String inUser, int inPID, String inCommand) {
        this.mUser = inUser;
        this.mProcessID = inPID;
        this.mCommand = inCommand;
    }

    public void setUser(String inUser) {
        this.mUser = inUser;
    }

    public void setProcessID(int inPID) {
        this.mProcessID = inPID;
    }

    public void setCommand(String inCommand) {
        this.mCommand = inCommand;
    }

    public String getUser() {
        return this.mUser;
    }

    public int getProcessID() {
        return this.mProcessID;
    }

    public String getCommand() {
        return this.mCommand;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Process (").append(this.mUser).append(", ").append(this.mProcessID).append(", ");
        sb.append(this.mCommand).append(")");
        return sb.toString();
    }

    public static Vector getSpecForProcess(ProcessSpec[] allProcs, RegEx inUser, RegEx inCommand) {
        if (inCommand == null || allProcs == null) {
            return null;
        }
        int nProcs = allProcs.length;
        Vector<ProcessSpec> result = new Vector<ProcessSpec>(5);
        if (Logger.isDebugEnabled(LOGGER_NAME)) {
            Logger.debug("Looking for process: user " + inUser + ", cmd: " + inCommand, LOGGER_NAME);
        }
        for (int i = 0; i < nProcs; ++i) {
            String procCommand;
            ProcessSpec oneSpec = allProcs[i];
            if (inUser != null && (oneSpec.getUser() == null || !inUser.match(oneSpec.getUser())) || (procCommand = oneSpec.getCommand()) == null) continue;
            if (Logger.isDebugEnabled(LOGGER_NAME)) {
                Logger.debug("fullCmd: " + procCommand, LOGGER_NAME);
            }
            if (!inCommand.match(procCommand)) continue;
            result.add(oneSpec);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public static String prettyPrintProcessSpecForOutput(Object[] procs) {
        StringBuffer output = new StringBuffer(512);
        for (int i = 0; i < procs.length; ++i) {
            ProcessSpec spec = (ProcessSpec)procs[i];
            output.append(spec.getCommand()).append(" (PID ").append(spec.getProcessID());
            output.append(", ").append(spec.getUser()).append(", ").append(")\n");
        }
        return output.toString();
    }

    public static ProcessSpec parsePSOutputLine(String line, int inCmdOffset) throws CommandExecutionErrorException {
        int pidInt;
        if (line == null) {
            throw new CommandExecutionErrorException("cmd.ERR_NULL_PS_CMD_LINE");
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        if (Logger.isDebugEnabled(LOGGER_NAME)) {
            Logger.debug("Parsing ps output:" + line, LOGGER_NAME);
        }
        String user = st.nextToken();
        String pid = st.nextToken();
        String cmd = line.substring(inCmdOffset);
        try {
            pidInt = Integer.parseInt(pid);
        }
        catch (NumberFormatException ex) {
            pidInt = 0;
        }
        return new ProcessSpec(user, pidInt, cmd);
    }

    public boolean equals(Object inObj) {
        if (inObj == null || !(inObj instanceof ProcessSpec)) {
            return false;
        }
        ProcessSpec inSpec = (ProcessSpec)inObj;
        return this.mUser.equals(inSpec.getUser()) && this.mProcessID == inSpec.getProcessID() && this.mCommand.equals(inSpec.getCommand());
    }
}

