/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command.commandresult;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.NativeCommandErrorException;
import com.raplix.rolloutexpress.command.exceptions.PathDoesNotExistException;
import com.raplix.rolloutexpress.command.rpcinterfaces.FileOperationsInterface;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.util.platform.common.Platform;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class FileSpec
implements Serializable,
RPCSerializable {
    public static final char UNIVERSAL_FILE_SEPARATOR_CHAR = '/';
    public static final String UNIVERSAL_FILE_SEPARATOR = String.valueOf('/');
    public static final char WINDOWS_DRIVE_SUFFIX_CHAR = ':';
    public static final String WINDOWS_DRIVE_SUFFIX = String.valueOf(':');
    public static final String WINDOWS_UNC_PATH = "\\\\";
    protected String mPath;
    protected long mSize;
    protected long mChecksum;
    protected String mResourceID = null;
    protected String mResourceVersion = null;
    private RoxAddress mRoxAddress = null;
    public static final int DEFAULT_GETFILEINFO_TIMEOUT = 600000;
    private static final String LOGGER = FileSpec.class.getName();
    public static final Comparator PATH_COMPARATOR = new FileSpecPathComparator();

    public FileSpec() {
    }

    public FileSpec(RoxAddress inAddress, String inPath, long inSize) {
        this.mRoxAddress = inAddress;
        this.mPath = FileSpec.convertPathSeparatorToUniversal(inPath);
        this.mSize = inSize;
    }

    public void setPath(String inPath) {
        this.mPath = inPath;
    }

    public void setSize(long inSize) {
        this.mSize = inSize;
    }

    public String getPath() {
        return this.mPath;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isSymlink() {
        return false;
    }

    public long getSize() {
        return this.mSize;
    }

    public RoxAddress getRoxAddress() {
        return this.mRoxAddress;
    }

    public String extractName() {
        int idx = this.mPath.lastIndexOf(UNIVERSAL_FILE_SEPARATOR);
        if (idx > 0) {
            if (idx == this.mPath.length() - 1) {
                int nextIdx = this.mPath.lastIndexOf(File.separatorChar, idx - 1);
                if (nextIdx < 0) {
                    return this.mPath.substring(0, idx);
                }
                return this.mPath.substring(nextIdx + 1, idx);
            }
            return this.mPath.substring(idx + 1);
        }
        return this.mPath;
    }

    public String toString() {
        return "FileSpec (" + this.mPath + ", " + this.mSize + ")";
    }

    public String getGlobalFilePath() {
        return UNIVERSAL_FILE_SEPARATOR + this.mRoxAddress.ipString() + "_" + this.mRoxAddress.getPort() + UNIVERSAL_FILE_SEPARATOR + this.mPath;
    }

    public static FileSpec[] getDirectoryFileSpecs(boolean followLinks, Application inApplication, Host inHost, String inAbsPath) throws RaplixException {
        RoxAddress address = inHost.getRARoxAddress();
        FileOperationsInterface fileOps = (FileOperationsInterface)inApplication.getRPCInterface(address, FileOperationsInterface.class);
        return fileOps.getDirFilesInfo(followLinks, inAbsPath);
    }

    public static FileSpec createFileSpec(boolean followLinks, FileOperationsInterface inFileOps, String inAbsPath) throws NativeCommandErrorException, CommandExecutionErrorException, PathDoesNotExistException, RPCException {
        return inFileOps.getFileInfo(followLinks, inAbsPath);
    }

    public static String convertPathSeparatorToLocal(String inPath) {
        if (inPath == null) {
            return null;
        }
        String result = inPath.replace(UNIVERSAL_FILE_SEPARATOR.charAt(0), File.separatorChar);
        return result;
    }

    public static String convertPathSeparatorToUniversal(String inPath) {
        if (inPath == null) {
            return null;
        }
        String result = inPath.replace(File.separatorChar, UNIVERSAL_FILE_SEPARATOR.charAt(0));
        return result;
    }

    public static String getFullTargetPath(String inInstallDir, ResourceDefinition inRsrc, MachineInfo inMI) throws PathDoesNotExistException {
        String targetPath = inRsrc.getInstallPath();
        boolean targetPathIsAbsolute = FileSpec.getIsAbsolutePath(targetPath, inMI);
        String targetName = inRsrc.getInstallName();
        if (StringUtil.isEmpty(targetName)) {
            throw new PathDoesNotExistException("cmd.EMPTY_INSTALL_NAME_DEPLOY");
        }
        StringBuffer result = new StringBuffer();
        if (!targetPathIsAbsolute) {
            if (StringUtil.isEmpty(inInstallDir)) {
                throw new PathDoesNotExistException("cmd.ERR_TARGET_PATH_CREATION", new Object[]{targetPath});
            }
            FileSpec.addPathAsUniversal(result, inInstallDir, inMI);
        }
        FileSpec.addPathAsUniversal(result, targetPath, inMI);
        FileSpec.addPathAsUniversal(result, targetName, inMI);
        return result.toString();
    }

    private static void addPathAsUniversal(StringBuffer rootPath, String newPath, MachineInfo mi) {
        int size;
        if (mi.getOSName() == null) {
            throw new NullPointerException("osName");
        }
        char fileSeparator = mi.getRAFileSeparator().charAt(0);
        boolean isWindows = mi.getRAPlatform().isWin32();
        boolean lastWasSeparator = false;
        if (rootPath.length() > 0) {
            char lastCh = rootPath.charAt(rootPath.length() - 1);
            if (lastCh != '/') {
                rootPath.append('/');
            }
            lastWasSeparator = true;
        }
        int len = newPath.length();
        for (int i = 0; i < len; ++i) {
            char ch = newPath.charAt(i);
            if (ch == fileSeparator || ch == '/') {
                if (lastWasSeparator && (!isWindows || rootPath.length() != 1)) continue;
                rootPath.append('/');
                lastWasSeparator = true;
                continue;
            }
            rootPath.append(ch);
            lastWasSeparator = false;
        }
        if (lastWasSeparator && (size = rootPath.length()) > 1) {
            if (isWindows && size == 2) {
                if (rootPath.charAt(0) != '/') {
                    rootPath.setLength(size - 1);
                }
            } else {
                rootPath.setLength(size - 1);
            }
        }
    }

    public static boolean getIsAbsolutePath(String inPath, MachineInfo inMI) {
        if (inMI.getOSName() == null) {
            throw new NullPointerException("osName");
        }
        Platform platf = inMI.getRAPlatform();
        if (platf.isWin32()) {
            if (inPath.length() < WINDOWS_UNC_PATH.length()) {
                return false;
            }
            if (inPath.startsWith(WINDOWS_UNC_PATH)) {
                return true;
            }
            if (inPath.length() < 3) {
                return false;
            }
            return Character.isLetter(inPath.charAt(0)) && inPath.charAt(1) == ':' && inPath.charAt(2) == '\\';
        }
        return inPath.startsWith(UNIVERSAL_FILE_SEPARATOR);
    }

    private static class FileSpecPathComparator
    implements Comparator {
        private FileSpecPathComparator() {
        }

        public int compare(Object o1, Object o2) {
            FileSpec spec1 = (FileSpec)o1;
            FileSpec spec2 = (FileSpec)o2;
            return spec1.getPath().compareTo(spec2.getPath());
        }
    }
}

