/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.command.impl.PosixNativePlatformIntegrationImpl;
import com.raplix.rolloutexpress.command.rpcinterfaces.NativePlatformIntegrationInterface;
import java.util.Vector;

public abstract class PosixNativePlatformIntegration
extends NativePlatformIntegration {
    private static final String CONFIG_VARNAME_LIST_PROCESSES_CMD = "processListFull";
    private static final String CONFIG_VARNAME_PARSE_CMD_OFFSET = "parseCmdOffset";

    protected PosixNativePlatformIntegration() {
    }

    protected PosixNativePlatformIntegration(Application inApplication) throws ConfigurationException {
        super(inApplication);
    }

    protected void addSubclassConfiguration(Vector config) {
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_LIST_PROCESSES_CMD, this.getDefaultProcessListCmd(), "This is the full invocation of the process list command.\nOn UNIX it might be /usr/ucb/ps -auxww"));
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_PARSE_CMD_OFFSET, this.getDefaultParseCmdOffset(), "This is the offset column for where the command starts in for the ListProcesses command.\n.On Solaris it might be 61"));
    }

    protected NativePlatformIntegrationInterface createNativeInterface() throws UnsupportedSubsystemException {
        return new PosixNativePlatformIntegrationImpl(this.mApplication, this);
    }

    protected abstract String getDefaultProcessListCmd();

    protected abstract String getDefaultParseCmdOffset();

    public String getConfigFullProcessListCommand() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_LIST_PROCESSES_CMD) + " ";
    }

    public int getConfigParseCmdOffset() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_PARSE_CMD_OFFSET);
    }
}

