/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.command;

import [Lcom.raplix.rolloutexpress.DefaultConfiguration;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.StringConstants;
import com.raplix.rolloutexpress.command.rpcinterfaces.NativePlatformIntegrationInterface;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStepExecManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.util.Vector;

public abstract class NativePlatformIntegration
extends Subsystem
implements StringConstants {
    private static final String CONFIG_PREFIX = "cmd.";
    private static final String CONFIG_VARNAME_DEFAULT_NATIVE_TIMEOUT_SECS = "defaultNativeTimeoutSecs";
    private static final String CONFIG_VARNAME_DEFAULT_WORKING_DIR = "defaultWorkingDir";
    private static final String CONFIG_VARNAME_DEFAULT_PATH_EXECUSER = "defaultExecUserPath";
    private static final String CONFIG_VARNAME_DEFAULT_PATH_EXECBKG = "defaultExecBkgPath";
    private static final String CONFIG_VARNAME_SHELL_DIFF_CMD = "diff";
    private static final String CONFIG_VARNAME_DIFF_IS_DIFFOUT = "isDiffOutput";
    private static final String DEFAULT_CONFIG_DEFAULT_NATIVE_TIMEOUT_SECS = "1800";
    private static final String DEFAULT_CONFIG_SHELL_DIFF_CMD = "/bin/diff";
    private static final String DEFAULT_CONFIG_DIFF_IS_DIFFOUT = "true";
    public static final String DEFAULT_COMMAND_WORK_DIR = "work";
    private NativePlatformIntegrationInterface mNativeInterface;
    private OutputGeneratorStepExecManager mOGStepManager;

    protected NativePlatformIntegration() {
    }

    protected NativePlatformIntegration(Application inApplication) throws ConfigurationException {
        super(inApplication);
        try {
            this.mOGStepManager = new OutputGeneratorStepExecManager();
            this.mNativeInterface = this.createNativeInterface();
        }
        catch (UnsupportedSubsystemException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to register native interface with RPC", ex, this);
            }
            throw new ConfigurationException("cmd.NO_SUBSYSTEM", (Throwable)ex);
        }
    }

    public void registerRPCInterfaces(RPCManager inRPC) throws RPCException {
        inRPC.registerService(NativePlatformIntegrationInterface.class, this.mNativeInterface);
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        String homeDirAbsPath = this.mApplication == null ? "" : this.mApplication.getHomeDirAbsPath();
        String defaultWorkingDir = homeDirAbsPath + File.separator + DEFAULT_COMMAND_WORK_DIR;
        String defaultExecUserPath = homeDirAbsPath + File.separator + "bin" + File.separator + "execuser";
        String defaultExecBkgPath = homeDirAbsPath + File.separator + "bin" + File.separator + "execbkg";
        Vector<DefaultConfiguration> config = new Vector<DefaultConfiguration>();
        this.addSubclassConfiguration(config);
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_DEFAULT_NATIVE_TIMEOUT_SECS, DEFAULT_CONFIG_DEFAULT_NATIVE_TIMEOUT_SECS, "This is the default timeout for all the commands that have to shell out to native in secs."));
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_DEFAULT_WORKING_DIR, defaultWorkingDir, "This is the default working directory for all the commands that have to shell out to native."));
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_DEFAULT_PATH_EXECUSER, defaultExecUserPath, "This is the default path for execuser utility for all the commands that have to shell out to native."));
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_DEFAULT_PATH_EXECBKG, defaultExecBkgPath, "This is the default path for execbkg utility for all the commands that have to shell out to native."));
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_SHELL_DIFF_CMD, this.getDefaultShellDiffCmd(), "This is the command used to diff files on a shell.\nOn UNIX it might be /bin/diff"));
        config.addElement(new DefaultConfiguration(CONFIG_VARNAME_DIFF_IS_DIFFOUT, this.getDefaultDiffIsDiffOut(), "This is a flag, set to true if the command used to diff files on a shell produces output in the form of the UNIX diff utility"));
        return (DefaultConfiguration[])CollectionUtil.mapClass(config, DefaultConfiguration;.class);
    }

    protected String getConfigurationPropertyPrefix() {
        return CONFIG_PREFIX;
    }

    protected void addSubclassConfiguration(Vector config) {
    }

    protected String getDefaultShellDiffCmd() {
        return DEFAULT_CONFIG_SHELL_DIFF_CMD;
    }

    protected String getDefaultDiffIsDiffOut() {
        return DEFAULT_CONFIG_DIFF_IS_DIFFOUT;
    }

    protected abstract NativePlatformIntegrationInterface createNativeInterface() throws UnsupportedSubsystemException;

    public int getConfigDefaultNativeTimeoutSecs() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DEFAULT_NATIVE_TIMEOUT_SECS);
    }

    public String getConfigWorkingDirOnAgent() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DEFAULT_WORKING_DIR);
    }

    public String getConfigExecUserPathOnAgent() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DEFAULT_PATH_EXECUSER);
    }

    public String getConfigShellDiffCommand() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_SHELL_DIFF_CMD) + " ";
    }

    public boolean getConfigDiffIsDiffOut() throws ConfigurationException {
        return this.getConfigurationAsBoolean(CONFIG_VARNAME_DIFF_IS_DIFFOUT);
    }

    public final NativePlatformIntegrationInterface getNativeInterface() {
        if (this.mNativeInterface == null) {
            throw new RuntimeException("Native interface is not initialized");
        }
        return this.mNativeInterface;
    }

    public final OutputGeneratorStepExecManager getOGStepManager() {
        return this.mOGStepManager;
    }

    public String getConfigExecBkgPathOnAgent() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DEFAULT_PATH_EXECBKG);
    }
}

