/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import [Lcom.raplix.rolloutexpress.command.stickydata.BagID;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.RequiredConfiguration;
import com.raplix.rolloutexpress.SubsystemID;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.StickyInterface;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.systemmodel.userdb.JobInfo;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.TaskPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Mapper;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.RunnableContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class Subsystem {
    public static final String CONFIG_METHOD_PREFIX = "getConfig";
    private static final String SUBSYSTEM_NAME = "System";
    private static final int SHUTDOWN_WAIT_INTERVAL = 2000;
    protected Application mApplication;
    protected DefaultConfiguration[] mDefaultConfigurations;
    protected boolean mIsShuttingDown = false;
    protected SubsystemID mSubsystemID;
    private HashMap mRunningTasks = new HashMap();
    private HashMap mStoppingTasks = new HashMap();

    public static void addConfigurationForSubsystem(Hashtable inTable, Class inSubsystemClass) throws ConfigurationException {
        Subsystem subsystemObj = null;
        try {
            Constructor<?> defaultConstructor = null;
            Constructor<?>[] construct = inSubsystemClass.getDeclaredConstructors();
            for (int k = 0; k < construct.length; ++k) {
                if (construct[k].getParameterTypes().length != 0) continue;
                defaultConstructor = construct[k];
                break;
            }
            if (defaultConstructor == null) {
                throw new ConfigurationException("Default constructor not found for:" + inSubsystemClass.getName());
            }
            defaultConstructor.setAccessible(true);
            subsystemObj = (Subsystem)defaultConstructor.newInstance(null);
        }
        catch (IllegalAccessException e) {
            Logger.error("Cannot create no-argument instance of subsystem " + inSubsystemClass.getName() + "for configuration file generation.", e, Subsystem.class.getName());
            throw new ConfigurationException("Cannot create no-argument instance of subsystem " + inSubsystemClass.getName() + "for configuration file generation.", (Throwable)e);
        }
        catch (InstantiationException e) {
            Logger.error("Cannot create no-argument instance of subsystem " + inSubsystemClass.getName() + "for configuration file generation.", e, Subsystem.class.getName());
            throw new ConfigurationException("Cannot create no-argument instance of subsystem " + inSubsystemClass.getName() + "for configuration file generation.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Logger.error("Cannot create no-argument instance of subsystem " + inSubsystemClass.getName() + "for configuration file generation.", e, Subsystem.class.getName());
            throw new ConfigurationException("Cannot create no-argument instance of subsystem " + inSubsystemClass.getName() + "for configuration file generation.", (Throwable)e);
        }
        String fileName = subsystemObj.getConfigurationFileName();
        StringBuffer buffer = (StringBuffer)inTable.get(fileName);
        if (buffer == null) {
            buffer = new StringBuffer();
            inTable.put(fileName, buffer);
        }
        Enumeration enumeration = subsystemObj.getConfigurationEnumeration();
        while (enumeration.hasMoreElements()) {
            String var = (String)enumeration.nextElement();
            String doc = "Mystery Variable FIXME";
            String val = "<operator must provide value>";
            try {
                doc = subsystemObj.getConfigurationDocumentation(var);
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            try {
                val = subsystemObj.getDefaultConfiguration(var);
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            BufferedReader reader = new BufferedReader(new StringReader(doc));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    buffer.append("# " + line + System.getProperty("line.separator"));
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
            String prefixedTag = subsystemObj.getPrefixedPropertyName(var);
            buffer.append(prefixedTag + "=" + val + System.getProperty("line.separator"));
            buffer.append(System.getProperty("line.separator"));
        }
    }

    protected Subsystem(Application inApplication) throws ConfigurationException {
        this.mApplication = inApplication;
        this.mDefaultConfigurations = this.getDefaultConfiguration();
        this.verifyConfiguration();
        this.mApplication.addSubsystem(this);
    }

    protected Subsystem(Application inApplication, SubsystemID subsystemID) throws ConfigurationException {
        this(inApplication);
        this.mSubsystemID = subsystemID;
    }

    protected Subsystem() {
        this.mDefaultConfigurations = this.getDefaultConfiguration();
    }

    protected void verifyConfiguration() throws ConfigurationException {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                if (!methods[i].getName().startsWith(CONFIG_METHOD_PREFIX) || methods[i].getName().startsWith("getConfigGenerator") || methods[i].getName().startsWith("getConfigParser") || methods[i].getName().startsWith("getConfiguration")) continue;
                this.verifySingleConfiguration(methods[i]);
                continue;
            }
            catch (InvocationTargetException ite) {
                throw new ConfigurationException(new ROXMessage("app.configuration_err_with_msg", this.getClass().getName()), (Throwable)ite);
            }
            catch (IllegalAccessException iae) {
                throw new ConfigurationException(new ROXMessage("app.configuration_err_with_msg", this.getClass().getName()), (Throwable)iae);
            }
        }
    }

    protected Object verifySingleConfiguration(Method inMethod) throws InvocationTargetException, IllegalAccessException {
        Object retVal = inMethod.invoke((Object)this, new Object[0]);
        return retVal;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        return null;
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
    }

    public boolean isShuttingDown() {
        return this.mIsShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForShutdown() throws RaplixShutdownException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("PrepareforShutdown Called for Subsystem: " + this.getSubsystemName(), this);
        }
        HashMap hashMap = this.mRunningTasks;
        synchronized (hashMap) {
            this.mIsShuttingDown = true;
            Iterator it = this.mRunningTasks.values().iterator();
            while (it.hasNext()) {
                SubsystemTaskInfo taskInfo = (SubsystemTaskInfo)it.next();
                ContextThread theTask = taskInfo.getThread();
                it.remove();
                String taskName = theTask.getContext().getName();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Stopping Subsystem Task: " + taskName + " because of subsystem shutdown", this);
                }
                this.mStoppingTasks.put(taskName, theTask);
                theTask.abort();
            }
        }
    }

    public void shutdown() throws RaplixShutdownException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Shutdown Called for Subsystem: " + this.getSubsystemName(), this);
        }
        if (this.mRunningTasks.size() > 0) {
            throw new RaplixShutdownException(new ROXMessage("app.SHUTDOWN_CALLED_HAS_RUNNING_TASKS", new String[]{this.getSubsystemName()}));
        }
        try {
            while (this.mStoppingTasks.size() > 0) {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSubsystemTask(RunnableContext inTask) throws RaplixShutdownException, UnsupportedSubsystemException {
        HashMap hashMap = this.mRunningTasks;
        synchronized (hashMap) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Starting Subsystem Task: " + inTask.getName().toString(), this);
            }
            if (this.mIsShuttingDown) {
                throw new RaplixShutdownException(new ROXMessage("app.REQUESTSHUTDOWN"));
            }
            SessionTable sessionTable = this.mApplication.getUserDBSubsystem().getSessionTable();
            ContextThread thread = sessionTable.createThreadForCurrentSession(inTask);
            Session session = sessionTable.getCurrentSession();
            UserID userID = null;
            if (session != null) {
                userID = session.getUserID();
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("start task: " + inTask.getName() + "with ID:" + userID, this);
            }
            this.mRunningTasks.put(inTask.getName(), new SubsystemTaskInfo(thread, userID));
            thread.start();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("DONE starting Subsystem Task: " + inTask.getName().toString(), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopSubsystemTask(String inTaskName) {
        HashMap hashMap = this.mRunningTasks;
        synchronized (hashMap) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Stopping Subsystem Task: " + inTaskName, this);
            }
            SubsystemTaskInfo theTask = (SubsystemTaskInfo)this.mRunningTasks.get(inTaskName);
            UserID taskOwner = null;
            if (theTask != null) {
                taskOwner = theTask.getTaskOwner();
            }
            if (Logger.isDebugEnabled(this)) {
                UserID currentUserID = null;
                try {
                    currentUserID = this.mApplication.getUserDBSubsystem().getLocalSessionManager().getCurrentUserID();
                }
                catch (Exception e) {
                    Logger.error("e", e, this);
                }
                Logger.debug("CurrentUser:" + currentUserID + ":attempting to stop task owned by:" + taskOwner, this);
            }
            Subsystem.checkTaskPermission(taskOwner);
            if (theTask != null) {
                this.mRunningTasks.remove(inTaskName);
                this.mStoppingTasks.put(inTaskName, theTask);
                theTask.getThread().abort();
                return true;
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Attemping to stop Subsystem Task " + inTaskName + " which didn't exist", this);
            }
            return false;
        }
    }

    public static void checkTaskPermission(UserID inTaskOwner) {
        if (Logger.isDebugEnabled(Subsystem.class)) {
            Logger.debug("Checking Task Permission for:" + inTaskOwner, Subsystem.class);
        }
        if (inTaskOwner != null) {
            AccessController.checkPermission(new TaskPermission(inTaskOwner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subsystemTaskComplete(String inTaskName) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Task Stop Complete Called for Task: " + inTaskName, this);
        }
        HashMap hashMap = this.mRunningTasks;
        synchronized (hashMap) {
            this.mRunningTasks.remove(inTaskName);
            this.mStoppingTasks.remove(inTaskName);
        }
    }

    public RunnableContext getRunningTask(String inTaskName) {
        SubsystemTaskInfo info = (SubsystemTaskInfo)this.mRunningTasks.get(inTaskName);
        if (info == null) {
            return null;
        }
        return info.getThread().getContext();
    }

    public UserID getTaskOwner(String inTaskName) {
        SubsystemTaskInfo info = (SubsystemTaskInfo)this.mRunningTasks.get(inTaskName);
        if (info == null) {
            info = (SubsystemTaskInfo)this.mStoppingTasks.get(inTaskName);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("getTaskOwner:" + inTaskName + ":Found:" + info + ":RunningTasks:" + this.mRunningTasks, this);
        }
        if (info != null) {
            return info.getTaskOwner();
        }
        return null;
    }

    public int getNumRunningTasks() {
        return this.mRunningTasks.size();
    }

    public int getNumStoppingTasks() {
        return this.mStoppingTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStaleResources(StickyInterface inSticky) throws RaplixException {
        HashMap hashMap = this.mRunningTasks;
        synchronized (hashMap) {
            String[] curTaskStrings = this.mRunningTasks.keySet().toArray(new String[0]);
            if (curTaskStrings == null || curTaskStrings.length == 0) {
                return;
            }
            try {
                BagID[] curBagIDs = (BagID[])CollectionUtil.mapClass(curTaskStrings, BagID;.class, new MyMapper());
                inSticky.removeOutsideBags(this.mSubsystemID, curBagIDs);
            }
            catch (Exception ex) {
                throw new RaplixException(ex);
            }
        }
    }

    protected final String getConfigurationAsString(String inConfigurationTag) throws ConfigurationException {
        return this.getConfiguration(inConfigurationTag);
    }

    protected final int getConfigurationAsInt(String inConfigurationTag) throws NumberFormatException, ConfigurationException {
        String value = null;
        try {
            value = this.getConfiguration(inConfigurationTag);
            if (value == null) {
                throw new ConfigurationException("Configuration tag \"" + inConfigurationTag + "\" has null value: cannot convert to an integer.");
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Configuration tag \"" + inConfigurationTag + "\" has value \"" + value + "\": cannot convert to an integer.");
        }
    }

    protected final long getConfigurationAsLong(String inConfigurationTag) throws NumberFormatException, ConfigurationException {
        String value = null;
        try {
            value = this.getConfiguration(inConfigurationTag);
            if (value == null) {
                throw new ConfigurationException("Configuration tag \"" + inConfigurationTag + "\" has null value: cannot convert to a long.");
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Configuration tag \"" + inConfigurationTag + "\" has value \"" + value + "\": cannot convert to a long.");
        }
    }

    protected final boolean getConfigurationAsBoolean(String inConfigurationTag) throws IllegalArgumentException, ConfigurationException {
        String value = this.getConfiguration(inConfigurationTag);
        if (value == null) {
            throw new ConfigurationException("Configuration tag \"" + inConfigurationTag + "\" has null value: cannot convert to a boolean.");
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ConfigurationException("Configuration tag \"" + inConfigurationTag + "\" has value \"" + value + "\": cannot convert to a boolean.");
    }

    private final String getConfiguration(String inConfigurationTag) throws ConfigurationException {
        return this.mApplication.getConfiguration(inConfigurationTag, this);
    }

    public String getDefaultConfiguration(String inConfigurationTag) throws ConfigurationException {
        if (this.mDefaultConfigurations != null) {
            for (int i = 0; i < this.mDefaultConfigurations.length; ++i) {
                if (!this.mDefaultConfigurations[i].mName.equalsIgnoreCase(inConfigurationTag)) continue;
                if (this.mDefaultConfigurations[i] instanceof RequiredConfiguration) {
                    throw new ConfigurationException("No default value for \"" + inConfigurationTag + "\".");
                }
                return this.mDefaultConfigurations[i].mValue;
            }
        }
        throw new ConfigurationException("No default value is defined for configuration variable \"" + inConfigurationTag + "\"");
    }

    public String getConfigurationDocumentation(String inConfigurationTag) throws ConfigurationException {
        if (this.mDefaultConfigurations != null) {
            for (int i = 0; i < this.mDefaultConfigurations.length; ++i) {
                if (!this.mDefaultConfigurations[i].mName.equalsIgnoreCase(inConfigurationTag)) continue;
                return this.mDefaultConfigurations[i].mDocumentation;
            }
        }
        throw new ConfigurationException("No documentation is defined for configuration variable \"" + inConfigurationTag + "\"");
    }

    public Enumeration getConfigurationEnumeration() {
        if (this.mDefaultConfigurations != null) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.mDefaultConfigurations.length; ++i) {
                v.addElement(this.mDefaultConfigurations[i].mName);
            }
            return v.elements();
        }
        return new Vector().elements();
    }

    public String getConfigurationFileName() {
        if (this.mApplication == null) {
            return Application.getGlobalDefaultConfigurationFileName();
        }
        return this.mApplication.getDefaultConfigurationFileName();
    }

    protected String getPrefixedPropertyName(String inPropertyName) {
        return Application.getPrefixedPropertyName(inPropertyName, this);
    }

    protected String getConfigurationPropertyPrefix() {
        return "";
    }

    public String getSubsystemName() {
        return Subsystem.getClassSubsystemName();
    }

    public static String getClassSubsystemName() {
        return SUBSYSTEM_NAME;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    HashMap getCurrentConfiguration() throws ConfigurationException {
        HashMap<String, String> current = new HashMap<String, String>();
        DefaultConfiguration[] configs = this.getDefaultConfiguration();
        if (configs != null) {
            for (int i = 0; i < configs.length; ++i) {
                DefaultConfiguration config = configs[i];
                String configuration = this.getConfiguration(config.mName);
                if (configuration == null) {
                    configuration = "";
                }
                current.put(this.getPrefixedPropertyName(config.mName), configuration);
            }
        }
        return current;
    }

    private class MyMapper
    implements Mapper {
        private MyMapper() {
        }

        public void setMappedClass(Class cls) {
        }

        public Object map(Object element) throws Exception {
            return new BagID((String)element);
        }
    }

    private static class SubsystemTaskInfo
    implements JobInfo {
        private ContextThread mThread;
        private UserID mTaskOwner;

        public SubsystemTaskInfo(ContextThread inThread, UserID inOwner) {
            this.mThread = inThread;
            this.mTaskOwner = inOwner;
        }

        public ContextThread getThread() {
            return this.mThread;
        }

        public UserID getTaskOwner() {
            return this.mTaskOwner;
        }

        public String toString() {
            return "SubsystemTaskInfo{mThread=" + this.mThread.getName() + ", mTaskOwner=" + this.mTaskOwner + "}";
        }
    }
}

