/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.util.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class SshProxy
extends Application {
    private NetSubsystem netSubsystem;
    private static File outFile = null;

    public static void main(String[] args) {
        block2: {
            try {
                InputStream is = System.in;
                PrintStream os = System.out;
                outFile = File.createTempFile("ROXProxy", ".log");
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                ByteArrayInputStream fis = new ByteArrayInputStream(new byte[0]);
                System.setIn(fis);
                System.setOut(out);
                System.setErr(out);
                SshProxy sshProxy = new SshProxy(args, is, os);
                sshProxy.start();
            }
            catch (Exception e) {
                System.out.println("Unable to start Proxy: " + e.toString());
                if (!Logger.isErrorEnabled(SshProxy.class)) break block2;
                Logger.error(e.toString(), e, SshProxy.class);
            }
        }
    }

    public SshProxy(String[] args, InputStream is, OutputStream os) throws ConfigurationException {
        super(args);
        this.netSubsystem = NetSubsystem.createNetSubsystemForProxy(this, is, os);
        this.netSubsystem.postInit();
    }

    protected String getVersionString() {
        return "Version x.x";
    }

    public NetSubsystem getNetSubsystem() {
        return this.netSubsystem;
    }

    protected void shutdown() throws RaplixShutdownException {
        this.netSubsystem.shutdown();
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
    }

    public void closedMainConnection() {
        try {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Main connection closed, Shutting down!", this);
            }
            this.shutdown();
            if (outFile != null && outFile.length() <= 0L) {
                outFile.delete();
            }
            this.exitProcess(0);
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error shutting down the connection after the main connection was closed", e, this);
            }
            this.exitProcess(1);
        }
    }

    public String promptForInput(String[] inPrompts) {
        return null;
    }
}

