/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Distributor;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.util.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class SshDistributor
extends Distributor {
    private InputStream in;
    private OutputStream out;
    private static File outFile = null;

    public static void main(String[] args) {
        block2: {
            try {
                InputStream is = System.in;
                PrintStream os = System.out;
                outFile = File.createTempFile("ROXDist", ".log");
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                ByteArrayInputStream fis = new ByteArrayInputStream(new byte[0]);
                System.setIn(fis);
                System.setOut(out);
                System.setErr(out);
                SshDistributor theDistributor = SshDistributor.createDistributor(args, is, os);
                theDistributor.start();
            }
            catch (Exception e) {
                System.out.println("Unable to start Distributor: " + e.toString());
                if (!Logger.isErrorEnabled("Distributor")) break block2;
                Logger.error(e.toString(), e, "Distributor");
            }
        }
    }

    public static SshDistributor createDistributor(String[] args, InputStream is, OutputStream os) throws ConfigurationException {
        SshDistributor theDistributor = new SshDistributor(args);
        theDistributor.mNetworkSubsystem = NetSubsystem.createNetSubsystemForNode(theDistributor, is, os);
        theDistributor.initSubsystems();
        return theDistributor;
    }

    private SshDistributor(String[] args) throws ConfigurationException {
        super(args);
    }

    public void closedMainConnection() {
        if (Logger.isInfoEnabled(this)) {
            Logger.info("Closed main connection, shutting down!", this);
        }
        this.forceEmergencyShutdown();
        if (outFile != null && outFile.length() <= 0L) {
            outFile.delete();
        }
    }

    public String promptForInput(String[] inPrompts) {
        return null;
    }
}

